/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin.theme;

import com.vaadin.sass.internal.ScssStylesheet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ThemeCustomizer {
    private static final Logger log = LoggerFactory.getLogger(ThemeCustomizer.class);
    private static final String THEMES_FOLDER = "VAADIN/themes/";
    private static final String FILTERABLE_EXTENSION = ".tscss";
    private static final String THEME_NAME_TOKEN = "THEME_NAME";
    private static final String MINIFY_CLASS = "com.yahoo.platform.yui.compressor.CssCompressor";
    private final PropertySources globalPropertySources;
    private boolean minifyStylesCss = this.isMinifyClassAvailable();

    public ThemeCustomizer(PropertySources propertySources) {
        this.globalPropertySources = propertySources;
    }

    private boolean isMinifyClassAvailable() {
        try {
            Class.forName(MINIFY_CLASS);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public void customizeTheme(String themeName, String customThemeName) throws ThemeCustomizerException {
        this.customizeTheme(themeName, customThemeName, Collections.emptyMap());
    }

    public void customizeTheme(String themeName, String customThemeName, Map<String, String> filesToCopy) throws ThemeCustomizerException {
        ScssStylesheet scssStylesheet;
        Path tempFolderPath;
        try {
            tempFolderPath = Files.createTempDirectory(customThemeName, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ThemeCustomizerException(String.format("Impossible de cr\u00e9er un dossier temporaire pour la personnalisation du theme %s.", themeName), e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Files.walk(tempFolderPath, new FileVisitOption[0]).map(Path::toFile).sorted((o1, o2) -> -o1.compareTo((File)o2)).forEach(File::delete);
            }
            catch (IOException e) {
                log.warn("Impossible de supprimer le dossier temporaire {}", (Object)tempFolderPath, (Object)e);
            }
        }));
        filesToCopy.forEach((source, dest) -> {
            log.info("Copie {} vers {}...", source, dest);
            try {
                Path sourceFile = Paths.get(source, new String[0]);
                Path destFile = tempFolderPath.resolve(THEMES_FOLDER + customThemeName).resolve((String)dest);
                Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                Files.copy(sourceFile, destFile, new CopyOption[0]);
            }
            catch (Exception e) {
                log.error("Impossible de copier {} dans le theme personnalis\u00e9 {}.", new Object[]{source, themeName, e});
            }
        });
        try {
            this.copyAndFilterFiles(themeName, customThemeName, tempFolderPath);
        }
        catch (Exception e) {
            throw new ThemeCustomizerException(String.format("Une erreur s'est produite lors de la personnalisation du theme %s.", themeName), e);
        }
        try {
            this.addPath(tempFolderPath.toUri().toURL());
        }
        catch (Exception e) {
            throw new ThemeCustomizerException(String.format("Impossible d'ajouter au classpath le dossier temporaire du theme personnalis\u00e9 %s.", themeName), e);
        }
        String scssFile = THEMES_FOLDER + customThemeName + "/styles.scss";
        try {
            scssStylesheet = ScssStylesheet.get((String)scssFile);
            if (scssStylesheet == null) {
                throw new ThemeCustomizerException(String.format("Impossible d'acc\u00e9der \u00e0 %s.", scssFile));
            }
            scssStylesheet.compile();
        }
        catch (Exception e) {
            throw new ThemeCustomizerException(String.format("Une erreur s'est produite lors de la compilation du theme personnalis\u00e9 %s.", themeName), e);
        }
        Path cssPath = tempFolderPath.resolve(THEMES_FOLDER + customThemeName).resolve("styles.css");
        log.info("G\u00e9n\u00e8re {}...", (Object)cssPath);
        try {
            BufferedWriter writer = Files.newBufferedWriter(cssPath, new OpenOption[0]);
            if (this.minifyStylesCss) {
                boolean minify = this.isMinifyClassAvailable();
                if (!minify) {
                    log.warn("Impossible de minifier styles.css, {} non disponible.", (Object)MINIFY_CLASS);
                }
                scssStylesheet.write((Writer)writer, minify);
            } else {
                scssStylesheet.write((Writer)writer);
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new ThemeCustomizerException(String.format("Impossible d'\u00e9crire le .css compil\u00e9 du theme personnalis\u00e9 %s.", themeName), e);
        }
    }

    private void copyAndFilterFiles(String sourceThemeName, String targetThemeName, Path tempPath) throws FileSystemNotFoundException, IllegalArgumentException, IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        String searchPattern = THEMES_FOLDER + sourceThemeName + "/**/*";
        Resource[] resourcesToFilter = resolver.getResources(searchPattern);
        Properties themeProperties = new Properties();
        themeProperties.setProperty(THEME_NAME_TOKEN, targetThemeName);
        PropertiesPropertySource themePropertySource = new PropertiesPropertySource("themePropertySource", themeProperties);
        MutablePropertySources themePropertySources = new MutablePropertySources(this.globalPropertySources);
        themePropertySources.addFirst((PropertySource)themePropertySource);
        PropertySourcesPropertyResolver propertyResolver = new PropertySourcesPropertyResolver((PropertySources)themePropertySources);
        int sourceThemePathLength = resolver.getResource(THEMES_FOLDER + sourceThemeName + '/').getURL().getPath().length();
        Path targetThemePath = tempPath.resolve(THEMES_FOLDER + targetThemeName);
        for (Resource resourceToFilter : resourcesToFilter) {
            String resourceClassPath = resourceToFilter.getURL().getPath().substring(sourceThemePathLength);
            boolean filterFile = resourceClassPath.endsWith(FILTERABLE_EXTENSION);
            Path targetPath = targetThemePath.resolve(filterFile ? resourceClassPath.replaceAll("\\.tscss$", ".scss") : resourceClassPath);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            if (filterFile) {
                log.info("G\u00e9n\u00e8re {}...", (Object)targetPath);
                Stream<String> filteredLinesStream = new BufferedReader(new InputStreamReader(resourceToFilter.getInputStream())).lines().map(arg_0 -> ((PropertyResolver)propertyResolver).resolveRequiredPlaceholders(arg_0));
                Files.write(targetPath, filteredLinesStream::iterator, new OpenOption[0]);
                continue;
            }
            if (Files.exists(targetPath, new LinkOption[0])) continue;
            log.info("Copie {}...", (Object)targetPath);
            Files.copy(resourceToFilter.getInputStream(), targetPath, new CopyOption[0]);
        }
    }

    public void addPath(URL url) throws Exception {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, url);
    }

    public boolean isMinifyStylesCss() {
        return this.minifyStylesCss;
    }

    public void setMinifyStylesCss(boolean minifyStylesCss) {
        this.minifyStylesCss = minifyStylesCss;
    }

    public class ThemeCustomizerException
    extends Exception {
        public ThemeCustomizerException(String message) {
            super(message);
        }

        public ThemeCustomizerException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

