/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.test.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.test.context.TestComponent;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.test.web.support.WebTestUtils;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.filter.GenericFilterBean;

@TestComponent
@Order(value=-2147483648)
public class MockUserFilter
extends GenericFilterBean {
    private SecurityContext securityContext;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        if (this.securityContext != null) {
            SecurityContextRepository securityContextRepository = WebTestUtils.getSecurityContextRepository((HttpServletRequest)servletRequest);
            HttpRequestResponseHolder requestResponseHolder = new HttpRequestResponseHolder(servletRequest, servletResponse);
            securityContextRepository.loadContext(requestResponseHolder);
            servletRequest = requestResponseHolder.getRequest();
            servletResponse = requestResponseHolder.getResponse();
            securityContextRepository.saveContext(this.securityContext, servletRequest, servletResponse);
            this.securityContext = null;
        }
        chain.doFilter(request, response);
    }

    public void authenticateNextRequest() {
        this.authenticateNextRequestAs("user", new String[0]);
    }

    public void authenticateNextRequestAs(String username, String ... roles) {
        List authorities = AuthorityUtils.createAuthorityList((String[])roles);
        User principal = new User(username, "password", (Collection)authorities);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)principal.getPassword(), principal.getAuthorities());
        this.securityContext = SecurityContextHolder.createEmptyContext();
        this.securityContext.setAuthentication((Authentication)authentication);
        SecurityContextHolder.setContext((SecurityContext)this.securityContext);
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }
}

