package fr.univlorraine.tools.vaadin.spring.data;

import java.util.Optional;
import java.util.stream.Collectors;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import com.vaadin.data.provider.Query;
import com.vaadin.shared.data.sort.SortDirection;

import lombok.Getter;

/**
 * QueryPageable.
 * @author Adrien Colson
 */
public class QueryPageable implements Pageable {

	@Getter
	private boolean ignoreCase = true;

	@Getter
	private int offset = 0;

	@Getter
	private int pageSize = 0;

	@Getter
	private int pageNumber = 0;

	@Getter
	private Sort sort = null;

	/**
	 * Constructeur.
	 * @param query query
	 */
	public QueryPageable(final Query<?, ?> query) {
		this(query, true);
	}

	/**
	 * Constructeur.
	 * @param query query
	 * @param ignoreCaseSet ignoreCaseSet
	 */
	public QueryPageable(final Query<?, ?> query, final boolean ignoreCaseSet) {
		super();
		ignoreCase = ignoreCaseSet;
		offset = query.getOffset();
		pageSize = query.getLimit();
		pageNumber = query.getOffset() / query.getLimit();

		sort = Optional.ofNullable(query.getSortOrders())
			.map(sortOrders -> sortOrders.stream()
				.map(sortOrder ->
				new Sort.Order(
					sortOrder.getDirection() == SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC,
					sortOrder.getSorted())
				)
				.map(order -> ignoreCase ? order.ignoreCase() : order)
				.collect(Collectors.toList())
			)
			.filter(orders -> !orders.isEmpty())
			.map(Sort::new)
			.orElse(null);
	}

	/**
	 * @see org.springframework.data.domain.Pageable#next()
	 */
	@Override
	public Pageable next() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see org.springframework.data.domain.Pageable#previousOrFirst()
	 */
	@Override
	public Pageable previousOrFirst() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see org.springframework.data.domain.Pageable#first()
	 */
	@Override
	public Pageable first() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see org.springframework.data.domain.Pageable#hasPrevious()
	 */
	@Override
	public boolean hasPrevious() {
		throw new UnsupportedOperationException();
	}

}
