/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.test.utils;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class ScreenshotRule
extends TestWatcher {
    private static final Logger log = LoggerFactory.getLogger(ScreenshotRule.class);
    public static final String CLASSNAME_TOKEN = "${classname}";
    public static final String METHODNAME_TOKEN = "${methodname}";
    public static final String DOT_EXTENSION = ".png";
    private Supplier<TakesScreenshot> takesScreenshotSupplier;
    private String screenshotsFolder;
    private String screenshotsFilename;

    private void setScreenshotsFolder(String newScreenshotsFolder) {
        this.screenshotsFolder = newScreenshotsFolder == null ? "." : newScreenshotsFolder;
    }

    private void setScreenshotsFilename(String newScreenshotsFilename) {
        this.screenshotsFilename = newScreenshotsFilename == null ? "failed_${classname}.${methodname}.png" : newScreenshotsFilename;
    }

    public ScreenshotRule(Supplier<TakesScreenshot> newTakesScreenshotSupplier, String newScreenshotsFolder, String newScreenshotsFilename) {
        this.takesScreenshotSupplier = newTakesScreenshotSupplier;
        this.setScreenshotsFolder(newScreenshotsFolder);
        this.setScreenshotsFilename(newScreenshotsFilename);
    }

    public ScreenshotRule(Supplier<TakesScreenshot> newTakesScreenshotSupplier, String newScreenshotsFolder) {
        this(newTakesScreenshotSupplier, newScreenshotsFolder, null);
    }

    public ScreenshotRule(Supplier<TakesScreenshot> newTakesScreenshotSupplier) {
        this(newTakesScreenshotSupplier, null);
    }

    public ScreenshotRule(TakesScreenshot takesScreenshot, String newScreenshotsFolder, String newScreenshotsFilename) {
        this(() -> takesScreenshot, newScreenshotsFolder, newScreenshotsFilename);
    }

    public ScreenshotRule(TakesScreenshot takesScreenshot, String newScreenshotsFolder) {
        this(takesScreenshot, newScreenshotsFolder, null);
    }

    public ScreenshotRule(TakesScreenshot takesScreenshot) {
        this(takesScreenshot, null);
    }

    protected void failed(Throwable throwable, Description description) {
        String folder = this.parseString(this.screenshotsFolder, description);
        String filename = this.parseString(this.screenshotsFilename, description);
        try {
            boolean dirCreated = new File(folder).mkdirs();
            if (dirCreated) {
                log.info("Screenshots directory created.");
            }
            byte[] screenshot = (byte[])this.takesScreenshotSupplier.get().getScreenshotAs(OutputType.BYTES);
            File outputfile = new File(folder + "/" + filename);
            FileCopyUtils.copy((byte[])screenshot, (File)outputfile);
        }
        catch (IOException e) {
            log.error("Failed to take screenshot.", (Throwable)e);
        }
    }

    private String parseString(String toParse, Description description) {
        return toParse.replace(CLASSNAME_TOKEN, description.getClassName()).replace(METHODNAME_TOKEN, description.getMethodName());
    }

    public Supplier<TakesScreenshot> getTakesScreenshotSupplier() {
        return this.takesScreenshotSupplier;
    }

    public void setTakesScreenshotSupplier(Supplier<TakesScreenshot> takesScreenshotSupplier) {
        this.takesScreenshotSupplier = takesScreenshotSupplier;
    }

    public String getScreenshotsFolder() {
        return this.screenshotsFolder;
    }

    public String getScreenshotsFilename() {
        return this.screenshotsFilename;
    }
}

