/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class UsernameTurboFilter
extends TurboFilter {
    private static final String USER_KEY = "username";

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable throwable) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null || !this.registerUsername(auth.getName())) {
            MDC.remove((String)USER_KEY);
        }
        return FilterReply.NEUTRAL;
    }

    private boolean registerUsername(String username) {
        if (username != null && !username.trim().isEmpty()) {
            MDC.put((String)USER_KEY, (String)username);
            return true;
        }
        return false;
    }
}

