/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin.theme;

import com.vaadin.sass.internal.ScssStylesheet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ThemeCustomizer {
    private static final Logger log = LoggerFactory.getLogger(ThemeCustomizer.class);
    private static final String THEMES_FOLDER = "VAADIN/themes/";
    private final Environment env;

    public ThemeCustomizer(Environment environment) {
        this.env = environment;
    }

    public void customizeTheme(String themeName) {
        this.customizeTheme(themeName, Collections.emptyMap());
    }

    public void customizeTheme(String themeName, Map<String, String> filesToCopy) {
        ScssStylesheet scssStylesheet;
        Path tempFolderPath;
        try {
            tempFolderPath = Files.createTempDirectory("actul-custom-theme", new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Impossible de cr\u00e9er un dossier temporaire pour la personnalisation du theme {}.", (Object)themeName, (Object)e);
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Files.walk(tempFolderPath, new FileVisitOption[0]).map(Path::toFile).sorted((o1, o2) -> -o1.compareTo((File)o2)).forEach(File::delete);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        String themeFolder = THEMES_FOLDER + themeName;
        filesToCopy.forEach((source, dest) -> {
            try {
                Path sourceFile = Paths.get(source, new String[0]);
                Path destFile = tempFolderPath.resolve(themeFolder).resolve((String)dest);
                log.info("Copie {}...", (Object)sourceFile);
                Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                Files.copy(sourceFile, destFile, new CopyOption[0]);
            }
            catch (Exception e) {
                log.error("Impossible de copier {} dans le theme personnalis\u00e9 {}.", new Object[]{source, themeName, e});
            }
        });
        try {
            this.filterFiles(themeFolder, tempFolderPath);
        }
        catch (IOException e) {
            log.error("Une erreur s'est produite lors de la personnalisation du theme {}.", (Object)themeName, (Object)e);
            return;
        }
        try {
            this.addPath(tempFolderPath.toUri().toURL());
        }
        catch (Exception e) {
            log.error("Impossible d'ajouter au classpath le dossier temporaire du theme personnalis\u00e9 {}.", (Object)themeName, (Object)e);
            return;
        }
        String scssFile = themeFolder + "/styles.scss";
        try {
            scssStylesheet = ScssStylesheet.get((String)scssFile);
            if (scssStylesheet == null) {
                log.error("Impossible d'acc\u00e9der \u00e0 {}.", (Object)scssFile);
                return;
            }
            scssStylesheet.compile();
        }
        catch (Exception e) {
            log.error("Une erreur s'est produite lors de la compilation du theme personnalis\u00e9 {}.", (Object)themeName, (Object)e);
            return;
        }
        Path cssPath = tempFolderPath.resolve(themeFolder).resolve("styles.css");
        log.info("G\u00e9n\u00e8re {}...", (Object)cssPath);
        try {
            BufferedWriter writer = Files.newBufferedWriter(cssPath, new OpenOption[0]);
            scssStylesheet.write((Writer)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            log.error("Impossible d'\u00e9crire le .css compil\u00e9 du theme personnalis\u00e9 {}.", (Object)themeName, (Object)e);
            return;
        }
    }

    private void filterFiles(String resourcesPath, Path tempThemeFolderPath) throws FileSystemNotFoundException, IllegalArgumentException, IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        String searchPattern = resourcesPath + "/**/*.tscss";
        Resource[] resourcesToFilter = resolver.getResources(searchPattern);
        String rootPath = resolver.getResource("/").getURL().getPath();
        for (Resource resourceToFilter : resourcesToFilter) {
            String resourceClassPath = resourceToFilter.getURL().getPath().substring(rootPath.length());
            Path targetPath = tempThemeFolderPath.resolve(resourceClassPath.replaceAll("\\.tscss$", ".scss"));
            Stream<String> filteredLinesStream = new BufferedReader(new InputStreamReader(resourceToFilter.getInputStream())).lines().map(arg_0 -> ((Environment)this.env).resolveRequiredPlaceholders(arg_0));
            log.info("G\u00e9n\u00e8re {}...", (Object)targetPath);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            Files.write(targetPath, filteredLinesStream::iterator, new OpenOption[0]);
        }
    }

    public void addPath(URL url) throws Exception {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, url);
    }
}

