/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin.spring.data;

import com.vaadin.data.provider.Query;
import com.vaadin.shared.data.sort.SortDirection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public final class QueryUtils {
    public static PageRequest createPageRequest(Query<?, ?> query) {
        return QueryUtils.createPageRequest(query, true);
    }

    public static PageRequest createPageRequest(Query<?, ?> query, boolean ignoreCase) {
        int page = query.getOffset() / query.getLimit();
        Sort sort = Optional.ofNullable(query.getSortOrders()).map(sortOrders -> sortOrders.stream().map(sortOrder -> new Sort.Order(sortOrder.getDirection() == SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC, sortOrder.getSorted())).map(order -> ignoreCase ? order.ignoreCase() : order).collect(Collectors.toList())).filter(orders -> !orders.isEmpty()).map(Sort::new).orElse(null);
        return new PageRequest(page, query.getLimit(), sort);
    }

    private QueryUtils() {
    }
}

