/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.test.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.test.context.TestComponent;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.test.web.support.WebTestUtils;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.filter.GenericFilterBean;

@TestComponent
@Order(value=-2147483648)
public class RequestParameterUserFilter
extends GenericFilterBean {
    public static final String ROLE_PARAMETER = "role";
    public static final String USERNAME_PARAMETER = "username";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        String username = servletRequest.getParameter(USERNAME_PARAMETER);
        if (username != null && !username.isEmpty()) {
            SecurityContextRepository securityContextRepository = WebTestUtils.getSecurityContextRepository((HttpServletRequest)servletRequest);
            HttpRequestResponseHolder requestResponseHolder = new HttpRequestResponseHolder(servletRequest, servletResponse);
            securityContextRepository.loadContext(requestResponseHolder);
            servletRequest = requestResponseHolder.getRequest();
            servletResponse = requestResponseHolder.getResponse();
            String[] roles = servletRequest.getParameterValues(ROLE_PARAMETER);
            SecurityContext securityContext = this.createSecurityContext(username, roles);
            SecurityContextHolder.setContext((SecurityContext)securityContext);
            securityContextRepository.saveContext(securityContext, servletRequest, servletResponse);
        }
        chain.doFilter(request, response);
    }

    private SecurityContext createSecurityContext(String username, String ... roles) {
        Collection<Object> authorities = roles == null ? Collections.emptySet() : AuthorityUtils.createAuthorityList((String[])roles);
        User principal = new User(username, "password", authorities);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)principal.getPassword(), principal.getAuthorities());
        SecurityContext securityContext = SecurityContextHolder.createEmptyContext();
        securityContext.setAuthentication((Authentication)authentication);
        return securityContext;
    }
}

