package fr.univlorraine.tools.vaadin.tracking;

import java.io.Serializable;

import com.vaadin.ui.Component;

/**
 * Interface d'observeurs d'événements permettant de tenir des statistiques de fréquentation.
 * @author Adrien Colson
 */
public interface IAnalyticsTracker extends Serializable {

	/**
	 * Suit l'affichage d'une vue.
	 * @param name le nom de la vue affichée
	 */
	void trackPageview(String name);

	/**
	 * Suit un événement.
	 * @param category catégorie de l'événement suivi
	 * @param action nom de l'événement suivi
	 */
	void trackEvent(String category, String action);

	/**
	 * Suit un événement.
	 * @param category catégorie de l'événement suivi
	 * @param action nom de l'événement suivi
	 * @param optLabel description de l'événement suivi
	 */
	void trackEvent(String category, String action, String optLabel);

	/**
	 * Suit un événement.
	 * @param category catégorie de l'événement suivi
	 * @param action nom de l'événement suivi
	 * @param optLabel description de l'événement suivi
	 * @param optValue une valeur associée à l'événement
	 */
	void trackEvent(String category, String action, String optLabel, Integer optValue);

	/**
	 * @return composant Vaadin permettant de s'inscrire / se désinscrire du suivi d'activité
	 */
	default Component getOptOutComponent() {
		return null;
	}

}
