package fr.univlorraine.tools.test.utils;

import java.util.ArrayList;
import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;

/**
 * Outils facilitant le test des exports POI.
 * @author Adrien Colson
 */
public final class PoiTestUtils {

	/**
	 * @param workbook workbook
	 * @return workbook converti en listes et en String
	 */
	public static List<List<List<String>>> workbookToObjects(final Workbook workbook) {
		final DataFormatter dataFormatter = new DataFormatter();
		final FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
		final List<List<List<String>>> sheetList = new ArrayList<>();
		workbook.forEach(sheet -> {
			final List<List<String>> rowList = new ArrayList<>();
			sheet.forEach(row -> {
				final List<String> cellList = new ArrayList<>();
				row.forEach(cell ->
					cellList.add(
						dataFormatter.formatCellValue(cell, cell.getCellType() == Cell.CELL_TYPE_FORMULA ? evaluator : null)
					)
				);
				rowList.add(cellList);
			});
			sheetList.add(rowList);
		});
		return sheetList;
	}

	/** Cache le constructeur, puisque c'est une classe utilitaire. */
	private PoiTestUtils() {
	}

}
