/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin.spring.security;

import com.vaadin.server.VaadinSession;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.util.Assert;

public class VaadinSecurityContextHolderStrategy
implements SecurityContextHolderStrategy {
    private static final ThreadLocal<SecurityContext> STARTUP_CONTEXT_HOLDER = new ThreadLocal();
    private static final ThreadLocal<SecurityContext> INHERITABLE_CONTEXT_HOLDER = new InheritableThreadLocal<SecurityContext>();

    public void clearContext() {
        STARTUP_CONTEXT_HOLDER.remove();
        INHERITABLE_CONTEXT_HOLDER.remove();
    }

    public SecurityContext getContext() {
        SecurityContext ctx;
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        SecurityContext startupSecurityContext = STARTUP_CONTEXT_HOLDER.get();
        if (vaadinSession == null) {
            ctx = startupSecurityContext == null ? INHERITABLE_CONTEXT_HOLDER.get() : startupSecurityContext;
        } else if (startupSecurityContext == null) {
            ctx = (SecurityContext)vaadinSession.getAttribute(SecurityContext.class);
        } else {
            STARTUP_CONTEXT_HOLDER.remove();
            vaadinSession.setAttribute(SecurityContext.class, (Object)startupSecurityContext);
            ctx = startupSecurityContext;
        }
        if (ctx == null) {
            ctx = this.createEmptyContext();
            this.setContext(ctx);
        }
        return ctx;
    }

    public void setContext(SecurityContext context) {
        Assert.notNull((Object)context, (String)"Only non-null SecurityContext instances are permitted");
        INHERITABLE_CONTEXT_HOLDER.set(context);
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession == null) {
            STARTUP_CONTEXT_HOLDER.set(context);
        } else {
            STARTUP_CONTEXT_HOLDER.remove();
            vaadinSession.setAttribute(SecurityContext.class, (Object)context);
        }
    }

    public SecurityContext createEmptyContext() {
        return new SecurityContextImpl();
    }
}

