package fr.univlorraine.tools.vaadin.tracking;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractJavaScriptExtension;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Sizeable.Unit;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;

import elemental.json.Json;
import elemental.json.JsonArray;

/**
 * Extension permettant d'intégrer Piwik.
 * @author Charlie Dubois
 * @author Adrien Colson
 */
@JavaScript("pwk_connector.js")
@SuppressWarnings("serial")
public class PiwikAnalyticsTracker extends AbstractJavaScriptExtension implements IAnalyticsTracker {

	private static final int OPT_OUT_WIDTH = 600;
	private static final int OPT_OUT_HEIGHT = 200;

	/** trackerUrl. */
	private final String trackerUrl;

	/**
	 * Initialise l'extension.
	 * @param targetUi UI à laquelle est associée l'extension
	 * @param trackerUrlSet url du tracker Piwik
	 * @param siteId id du site Piwik
	 */
	public PiwikAnalyticsTracker(final UI targetUi, final String trackerUrlSet, final String siteId) {
		super();
		super.extend(targetUi);
		trackerUrl = trackerUrlSet;
		callFunction("setPiwikAccountCommand", trackerUrl, siteId);
	}

	/**
	 * Appelle une fonction Piwik.
	 * @param commandAndArguments nom de la commande suivi de ses arguments
	 */
	private void pushCommand(final Object... commandAndArguments) {
		final JsonArray ja = Json.createArray();
		for (int i = 0; i < commandAndArguments.length; i++) {
			ja.set(i, String.valueOf(commandAndArguments[i]));
		}
		callFunction("pushCommand", ja);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.tracking.IAnalyticsTracker#trackPageview(java.lang.String)
	 */
	@Override
	public void trackPageview(final String name) {
		pushCommand("trackPageView", name);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.tracking.IAnalyticsTracker#trackEvent(java.lang.String, java.lang.String)
	 */
	@Override
	public void trackEvent(final String category, final String action) {
		pushCommand("trackEvent", category, action);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.tracking.IAnalyticsTracker#trackEvent(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public void trackEvent(final String category, final String action, final String optLabel) {
		pushCommand("trackEvent", category, action, optLabel);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.tracking.IAnalyticsTracker#trackEvent(java.lang.String, java.lang.String, java.lang.String, java.lang.Integer)
	 */
	@Override
	public void trackEvent(final String category, final String action, final String optLabel, final Integer optValue) {
		pushCommand("trackEvent", category, action, optLabel, optValue);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.tracking.IAnalyticsTracker#getOptOutComponent()
	 */
	@Override
	public Component getOptOutComponent() {
		final BrowserFrame optOutComponent = new BrowserFrame(null, new ExternalResource("//" + trackerUrl + "/index.php?module=CoreAdminHome&action=optOut&language=fr"));
		optOutComponent.setWidth(OPT_OUT_WIDTH, Unit.PIXELS);
		optOutComponent.setHeight(OPT_OUT_HEIGHT, Unit.PIXELS);
		return optOutComponent;
	}

}
