package fr.univlorraine.tools.vaadin.tracking;

import lombok.extern.slf4j.Slf4j;

/**
 * IAnalyticsTracker utilisant un logger.
 * @author Adrien Colson
 */
@Slf4j
@SuppressWarnings("serial")
public class LogAnalyticsTracker implements IAnalyticsTracker {

	/**
	 * @see fr.univlorraine.tools.vaadin.tracking.IAnalyticsTracker#trackPageview(java.lang.String)
	 */
	@Override
	public void trackPageview(final String name) {
		log.debug("trackPageView({})", name);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.tracking.IAnalyticsTracker#trackEvent(java.lang.String, java.lang.String)
	 */
	@Override
	public void trackEvent(final String category, final String action) {
		log.debug("trackEvent({}, {})", category, action);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.tracking.IAnalyticsTracker#trackEvent(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public void trackEvent(final String category, final String action, final String optLabel) {
		log.debug("trackEvent({}, {}, {})", category, action, optLabel);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.tracking.IAnalyticsTracker#trackEvent(java.lang.String, java.lang.String, java.lang.String, java.lang.Integer)
	 */
	@Override
	public void trackEvent(final String category, final String action, final String optLabel, final Integer optValue) {
		log.debug("trackEvent({}, {}, {}, {})", category, action, optLabel, optValue);
	}

}
