package fr.univlorraine.tools.vaadin.spring.data;

import java.util.stream.Collectors;

import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

import com.vaadin.data.provider.Query;
import com.vaadin.shared.data.sort.SortDirection;

/**
 * Outils de manipulation des Query Vaadin.
 * @author Adrien Colson
 */
public final class QueryUtils {

	/**
	 * @param query dataProvider query
	 * @return Spring Data PageRequest
	 */
	public static PageRequest createPageRequest(final Query<?, ?> query) {
		final int page = query.getOffset() / query.getLimit();

		final Sort sort = new Sort(
			query.getSortOrders().stream()
				.map(sortOrder -> new Sort.Order(
					sortOrder.getDirection() == SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC,
					sortOrder.getSorted())
				)
				.collect(Collectors.toList())
		);

		return new PageRequest(page, query.getLimit(), sort);
	}

	/** Cache le constructeur, puisque c'est une classe utilitaire. */
	private QueryUtils() {
	}

}
