/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin.tracking;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractJavaScriptExtension;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import elemental.json.Json;
import elemental.json.JsonArray;
import fr.univlorraine.tools.vaadin.tracking.IAnalyticsTracker;

@JavaScript(value={"pwk_connector.js"})
public class PiwikAnalyticsTracker
extends AbstractJavaScriptExtension
implements IAnalyticsTracker {
    private static final int OPT_OUT_WIDTH = 600;
    private static final int OPT_OUT_HEIGHT = 200;
    private final String trackerUrl;

    public PiwikAnalyticsTracker(UI targetUi, String trackerUrlSet, String siteId) {
        super.extend((AbstractClientConnector)targetUi);
        this.trackerUrl = trackerUrlSet;
        this.callFunction("setPiwikAccountCommand", new Object[]{this.trackerUrl, siteId});
    }

    private void pushCommand(Object ... commandAndArguments) {
        JsonArray ja = Json.createArray();
        for (int i = 0; i < commandAndArguments.length; ++i) {
            ja.set(i, String.valueOf(commandAndArguments[i]));
        }
        this.callFunction("pushCommand", new Object[]{ja});
    }

    @Override
    public void trackPageview(String name) {
        this.pushCommand("trackPageView", name);
    }

    @Override
    public void trackEvent(String category, String action) {
        this.pushCommand("trackEvent", category, action);
    }

    @Override
    public void trackEvent(String category, String action, String optLabel) {
        this.pushCommand("trackEvent", category, action, optLabel);
    }

    @Override
    public void trackEvent(String category, String action, String optLabel, Integer optValue) {
        this.pushCommand("trackEvent", category, action, optLabel, optValue);
    }

    @Override
    public Component getOptOutComponent() {
        BrowserFrame optOutComponent = new BrowserFrame(null, (Resource)new ExternalResource("//" + this.trackerUrl + "/index.php?module=CoreAdminHome&action=optOut&language=fr"));
        optOutComponent.setWidth(600.0f, Sizeable.Unit.PIXELS);
        optOutComponent.setHeight(200.0f, Sizeable.Unit.PIXELS);
        return optOutComponent;
    }
}

