/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin.spring.security;

import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.util.Assert;

public class VaadinSecurityContextHolderStrategy
implements SecurityContextHolderStrategy {
    private static final Logger log = LoggerFactory.getLogger(VaadinSecurityContextHolderStrategy.class);
    private static final ThreadLocal<SecurityContext> CONTEXT_HOLDER = new InheritableThreadLocal<SecurityContext>();

    public void clearContext() {
        CONTEXT_HOLDER.remove();
    }

    public SecurityContext getContext() {
        SecurityContext ctx = (SecurityContext)Optional.ofNullable(UI.getCurrent()).map(UI::getSession).map(VaadinSession::getSession).map(httpSession -> {
            try {
                return httpSession.getAttribute("SPRING_SECURITY_CONTEXT");
            }
            catch (IllegalStateException e) {
                return null;
            }
        }).orElse(CONTEXT_HOLDER.get());
        if (ctx == null) {
            ctx = this.createEmptyContext();
            this.setContext(ctx);
        }
        return ctx;
    }

    public void setContext(SecurityContext context) {
        Assert.notNull((Object)context, (String)"Only non-null SecurityContext instances are permitted");
        CONTEXT_HOLDER.set(context);
        Optional.ofNullable(UI.getCurrent()).map(UI::getSession).map(VaadinSession::getSession).ifPresent(httpSession -> {
            try {
                httpSession.setAttribute("SPRING_SECURITY_CONTEXT", (Object)context);
            }
            catch (IllegalStateException e) {
                log.trace("Can't set context attribute in vaadin session.");
            }
        });
    }

    public SecurityContext createEmptyContext() {
        return new SecurityContextImpl();
    }
}

