/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin;

import com.vaadin.server.RequestHandler;
import com.vaadin.server.StreamResource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import fr.univlorraine.tools.vaadin.BusyIndicatorWindow;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class BusyIndicatorLongFileDownloader {
    private static final int BUFFER_SIZE = 1024;
    private StreamResource streamResource;

    public BusyIndicatorLongFileDownloader(StreamResource streamResourceSet) {
        this.streamResource = streamResourceSet;
    }

    public StreamResource getStreamResource() {
        return this.streamResource;
    }

    public void setStreamResource(StreamResource streamResourceSet) {
        this.streamResource = streamResourceSet;
    }

    public void download() {
        BusyIndicatorWindow busyIndicatorWindow = new BusyIndicatorWindow();
        UI ui = UI.getCurrent();
        ui.access(() -> ui.addWindow((Window)busyIndicatorWindow));
        new Thread(() -> {
            try {
                ResourceDownloadRequestHandler rh = new ResourceDownloadRequestHandler(ui.getSession(), this.streamResource.getStreamSource().getStream(), this.streamResource.getFilename(), this.streamResource.getMIMEType());
                ui.access(() -> ui.getPage().open(rh.getUrl(), "_blank"));
            }
            finally {
                busyIndicatorWindow.getUI().access(() -> busyIndicatorWindow.close());
            }
        }).start();
    }

    static class ResourceDownloadRequestHandler
    implements RequestHandler {
        private static final String DOWNLOAD_PREFIX = "/download";
        private static final String ID_PARAMETER = "id";
        private final VaadinSession vaadinSession;
        private final String id = UUID.randomUUID().toString();
        private final InputStream inputStream;
        private final String filename;
        private final String contentType;

        ResourceDownloadRequestHandler(VaadinSession vaadinSessionSet, InputStream inputStreamSet, String filenameSet, String contentTypeSet) {
            this.vaadinSession = vaadinSessionSet;
            this.inputStream = inputStreamSet;
            this.filename = filenameSet;
            this.contentType = contentTypeSet;
            vaadinSessionSet.addRequestHandler((RequestHandler)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
            if (DOWNLOAD_PREFIX.equals(request.getPathInfo()) && this.id instanceof String && this.id.equals(request.getParameter(ID_PARAMETER))) {
                try {
                    response.setHeader("Expires", "0");
                    response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                    response.setHeader("Pragma", "public");
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + this.filename + "\"");
                    response.setContentType(this.contentType);
                    OutputStream os = response.getOutputStream();
                    byte[] buffer = new byte[1024];
                    int len = this.inputStream.read(buffer);
                    while (len > 0) {
                        os.write(buffer, 0, len);
                        len = this.inputStream.read(buffer);
                    }
                    this.inputStream.close();
                    os.flush();
                    os.close();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.vaadinSession.removeRequestHandler((RequestHandler)this);
                }
            }
            return false;
        }

        public String getUrl() {
            return "/download?id=" + this.id;
        }
    }
}

