/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.logback;

import ch.qos.logback.classic.net.SMTPAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.helpers.CyclicBuffer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupEventsSMTPAppender
extends SMTPAppender {
    private transient Logger logger = LoggerFactory.getLogger(GroupEventsSMTPAppender.class);
    public static final String SEND_MAIL_MESSAGE = "sendMail!";
    private int mailDelaySeconds = 1;
    private transient Timer timer = new Timer();
    private transient TimerTask currentTimerTask;
    private transient ILoggingEvent lastEventObject;

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.logger = LoggerFactory.getLogger(GroupEventsSMTPAppender.class);
        this.timer = new Timer();
    }

    public int getMailDelaySeconds() {
        return this.mailDelaySeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMailDelaySeconds(int mailDelaySecondsSet) {
        GroupEventsSMTPAppender groupEventsSMTPAppender = this;
        synchronized (groupEventsSMTPAppender) {
            this.mailDelaySeconds = mailDelaySecondsSet;
        }
    }

    protected final void append(ILoggingEvent eventObject) {
        boolean isEventToProcess;
        if (SEND_MAIL_MESSAGE.equals(eventObject.getMessage())) {
            this.sendMail();
            return;
        }
        try {
            isEventToProcess = this.eventEvaluator.evaluate((Object)eventObject);
        }
        catch (EvaluationException e) {
            this.logger.error("Impossible de v\u00e9rifier si l'\u00e9l\u00e9ment est \u00e0 traiter.", (Throwable)e);
            return;
        }
        if (isEventToProcess) {
            if (this.cbTracker == null) {
                super.append((Object)eventObject);
            } else {
                this.processEvent(eventObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(ILoggingEvent eventObject) {
        GroupEventsSMTPAppender groupEventsSMTPAppender = this;
        synchronized (groupEventsSMTPAppender) {
            String key = this.discriminator.getDiscriminatingValue((Object)eventObject);
            CyclicBuffer cb = (CyclicBuffer)this.cbTracker.getOrCreate(key, System.currentTimeMillis());
            if (this.lastEventObject != null) {
                this.subAppend(cb, this.lastEventObject);
            }
            this.lastEventObject = eventObject;
            if (cb.length() >= cb.getMaxSize()) {
                if (this.currentTimerTask instanceof TimerTask) {
                    this.currentTimerTask.cancel();
                    this.currentTimerTask = null;
                }
                this.sendMail();
            } else if (this.currentTimerTask == null) {
                this.currentTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        GroupEventsSMTPAppender.this.sendMail();
                        GroupEventsSMTPAppender.this.currentTimerTask = null;
                    }
                };
                this.timer.schedule(this.currentTimerTask, TimeUnit.MILLISECONDS.convert(this.mailDelaySeconds, TimeUnit.SECONDS));
            }
        }
    }

    private void sendMail() {
        if (this.lastEventObject != null) {
            super.append((Object)this.lastEventObject);
            this.lastEventObject = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        GroupEventsSMTPAppender groupEventsSMTPAppender = this;
        synchronized (groupEventsSMTPAppender) {
            this.sendMail();
            super.stop();
        }
    }
}

