/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.atmosphere;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class RecoverSecurityContextAtmosphereInterceptor
implements AtmosphereInterceptor {
    private transient Logger logger = LoggerFactory.getLogger(RecoverSecurityContextAtmosphereInterceptor.class);

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.logger = LoggerFactory.getLogger(RecoverSecurityContextAtmosphereInterceptor.class);
    }

    public void configure(AtmosphereConfig atmosphereConfig) {
    }

    public Action inspect(AtmosphereResource atmosphereResource) {
        this.logger.trace("Recover SecurityContext in SecurityContextHolder");
        SecurityContext context = (SecurityContext)atmosphereResource.getRequest().getSession().getAttribute("SPRING_SECURITY_CONTEXT");
        SecurityContextHolder.setContext((SecurityContext)context);
        Authentication auth = context.getAuthentication();
        if (auth instanceof Authentication) {
            MDC.put((String)"username", (String)auth.getName());
            this.logger.trace("Username set in MDC");
        }
        return Action.CONTINUE;
    }

    public void postInspect(AtmosphereResource atmosphereResource) {
        MDC.remove((String)"username");
        this.logger.trace("Username removed from MDC");
    }
}

