package fr.univlorraine.tools.vaadin;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;

/**
 * Fenêtre affichée pour indiquer un état occupé.
 * @author Adrien Colson
 */
@SuppressWarnings("serial")
public class BusyIndicatorWindow extends Window {

	/**
	 * Constructeur.
	 */
	public BusyIndicatorWindow() {
		super();
		setModal(true);
		setDraggable(false);
		setResizable(false);
		setClosable(false);

		final VerticalLayout layout = new VerticalLayout();
		layout.setMargin(true);
		setContent(layout);

		final ProgressBar busyIndicator = new ProgressBar();
		busyIndicator.setIndeterminate(true);
		layout.addComponent(busyIndicator);
		layout.setComponentAlignment(busyIndicator, Alignment.MIDDLE_CENTER);

		center();
	}

}
