/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewProvider;
import ru.xpoft.vaadin.SpringApplicationContext;
import ru.xpoft.vaadin.VaadinView;
import ru.xpoft.vaadin.ViewCacheContainer;

public class SpringErrorViewProvider
implements ViewProvider {
    private final String beanName;
    private final VaadinView vaadinView;
    private final ViewCacheContainer cacheContainer;

    public SpringErrorViewProvider(Class<? extends View> viewClass, ViewCacheContainer cacheContainerSet) {
        if (viewClass == null || cacheContainerSet == null) {
            throw new IllegalArgumentException("viewClass and cacheContainer must be non-null");
        }
        if (!View.class.isAssignableFrom(viewClass)) {
            throw new IllegalArgumentException("viewClass must extend View");
        }
        if (!viewClass.isAnnotationPresent(VaadinView.class)) {
            throw new IllegalArgumentException("viewClass must have @VaadinView annotation");
        }
        String[] beanNames = SpringApplicationContext.getApplicationContext().getBeanNamesForType(viewClass);
        if (beanNames.length != 1) {
            throw new IllegalArgumentException("cant't resolve bean name for class: " + viewClass.getName());
        }
        this.beanName = beanNames[0];
        this.vaadinView = viewClass.getAnnotation(VaadinView.class);
        this.cacheContainer = cacheContainerSet;
    }

    public String getViewName(String viewAndParameters) {
        return this.vaadinView.value();
    }

    public View getView(String viewName) {
        return this.cacheContainer.getView(this.vaadinView.value(), this.beanName, this.vaadinView.cached());
    }
}

