/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin;

import com.vaadin.annotations.JavaScript;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractJavaScriptExtension;
import com.vaadin.ui.UI;
import elemental.json.Json;
import elemental.json.JsonArray;
import fr.univlorraine.tools.vaadin.IAnalyticsTracker;

@JavaScript(value={"ga_connector.js"})
public class GoogleAnalyticsTracker
extends AbstractJavaScriptExtension
implements IAnalyticsTracker {
    private static final String TRACKEVENT_COMMAND = "_trackEvent";

    public GoogleAnalyticsTracker(UI targetUi, String accountId) {
        super.extend((AbstractClientConnector)targetUi);
        this.pushCommand("_setAccount", accountId);
    }

    private void pushCommand(Object ... commandAndArguments) {
        JsonArray ja = Json.createArray();
        for (int i = 0; i < commandAndArguments.length; ++i) {
            ja.set(i, String.valueOf(commandAndArguments[i]));
        }
        this.callFunction("pushCommand", new Object[]{ja});
    }

    public void setDomainName(String domainName) {
        this.pushCommand("_setDomainName", domainName);
    }

    @Override
    public void trackPageview(String name) {
        this.pushCommand("_trackPageview", name);
    }

    @Override
    public void trackEvent(String category, String action) {
        this.pushCommand(TRACKEVENT_COMMAND, category, action);
    }

    @Override
    public void trackEvent(String category, String action, String optLabel) {
        this.pushCommand(TRACKEVENT_COMMAND, category, action, optLabel);
    }

    @Override
    public void trackEvent(String category, String action, String optLabel, Integer optValue) {
        this.pushCommand(TRACKEVENT_COMMAND, category, action, optLabel, optValue);
    }

    public void trackEvent(String category, String action, String optLabel, Integer optValue, Boolean optNoninteraction) {
        this.pushCommand(TRACKEVENT_COMMAND, category, action, optLabel, optValue, optNoninteraction);
    }

    @Override
    public void trackNavigator(Navigator navigator) {
        navigator.addViewChangeListener(new ViewChangeListener(){

            public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
                return true;
            }

            public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
                GoogleAnalyticsTracker.this.trackPageview(event.getViewName());
            }
        });
    }
}

