/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin;

import com.vaadin.ui.UI;
import fr.univlorraine.tools.vaadin.EntityPushListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EntityPusher<ENTITY_TYPE> {
    private final Class<? super ENTITY_TYPE> entityType;
    private transient ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final List<EntityPushListener<? super ENTITY_TYPE>> entityPushListeners = new LinkedList<EntityPushListener<? super ENTITY_TYPE>>();

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public EntityPusher(Class<? super ENTITY_TYPE> entityTypeSet) {
        this.entityType = entityTypeSet;
    }

    public Class<? super ENTITY_TYPE> getEntityType() {
        return this.entityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEntityPushListener(EntityPushListener<? super ENTITY_TYPE> entityPushListener) {
        EntityPusher entityPusher = this;
        synchronized (entityPusher) {
            this.entityPushListeners.add(entityPushListener);
        }
    }

    public List<EntityPushListener<? super ENTITY_TYPE>> getEntityPushListeners() {
        return this.entityPushListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEntityPushListener(EntityPushListener<? super ENTITY_TYPE> entityPushListener) {
        EntityPusher entityPusher = this;
        synchronized (entityPusher) {
            this.entityPushListeners.remove(entityPushListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAll(EntityAction entityAction, ENTITY_TYPE entity) {
        EntityPusher entityPusher = this;
        synchronized (entityPusher) {
            this.entityPushListeners.stream().filter(entityPushListener -> entityPushListener.getUI() instanceof UI && entityPushListener.getUI().isAttached()).forEach(entityPushListener -> this.executorService.execute(() -> {
                UI pusherUI = entityPushListener.getUI();
                if (pusherUI instanceof UI) {
                    pusherUI.access(() -> {
                        switch (entityAction) {
                            case PERSISTED: {
                                entityPushListener.entityPersisted(entity);
                                break;
                            }
                            case UPDATED: {
                                entityPushListener.entityUpdated(entity);
                                break;
                            }
                            case REMOVED: {
                                entityPushListener.entityDeleted(entity);
                                break;
                            }
                        }
                    });
                }
            }));
        }
    }

    public static enum EntityAction {
        PERSISTED,
        UPDATED,
        REMOVED;

    }
}

