package fr.univlorraine.tools.vaadin;

import com.vaadin.data.util.BeanContainer;

/**
 * BeanContainer utilisant l'IdentityBeanIdResolver.
 * @author Adrien Colson
 * @param <BEANTYPE> type de bean
 */
@SuppressWarnings("serial")
public class IdentityBeanContainer<BEANTYPE> extends BeanContainer<Integer, BEANTYPE> {

	/**
	 * Constructeur.
	 * @param type type de bean
	 */
	public IdentityBeanContainer(final Class<? super BEANTYPE> type) {
		super(type);
		setBeanIdResolver(new IdentityBeanIdResolver<BEANTYPE>());
	}

}
