package fr.univlorraine.tools.vaadin;

import java.io.Serializable;

import com.vaadin.navigator.Navigator;

/**
 * Interface d'observeurs d'événements permettant de tenir des statistiques de fréquentation.
 * @author Adrien Colson
 */
public interface IAnalyticsTracker extends Serializable {

	/**
	 * Suis l'affichage d'une vue.
	 * @param name le nom de la vue affichée
	 */
	void trackPageview(String name);

	/**
	 * Suis un événement.
	 * @param category catégorie de l'événement suivi
	 * @param action nom de l'événement suivi
	 */
	void trackEvent(String category, String action);

	/**
	 * Suis un événement.
	 * @param category catégorie de l'événement suivi
	 * @param action nom de l'événement suivi
	 * @param optLabel description de l'événement suivi
	 */
	void trackEvent(String category, String action, String optLabel);

	/**
	 * Suis un événement.
	 * @param category catégorie de l'événement suivi
	 * @param action nom de l'événement suivi
	 * @param optLabel description de l'événement suivi
	 * @param optValue une valeur associée à l'événement
	 */
	void trackEvent(String category, String action, String optLabel, Integer optValue);

	/**
	 * Active le suivi lors de changements de vues sur un navigator.
	 * @param navigator navigator à suivre
	 */
	void trackNavigator(Navigator navigator);

}
