package fr.univlorraine.tools.vaadin;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.ServletException;

import ru.xpoft.vaadin.SpringVaadinServlet;

import com.vaadin.server.Page;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.UnsupportedBrowserHandler;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.WebBrowser;

/**
 * SpringVaadinServlet qui affiche un message d'erreur en francais lorsque le navigateur n'est pas supporté.
 * @author Adrien Colson
 */
@SuppressWarnings("serial")
public class FrenchUnsupportedBrowserHandlerSpringVaadinServlet extends SpringVaadinServlet {

	/**
	 * Processeur de navigateur non supporté localisé.
	 * @author Adrien Colson
	 */
	static class LocalizedUnsupportedBrowserHandler extends UnsupportedBrowserHandler implements SessionInitListener {

		/**
		 * @see com.vaadin.server.SessionInitListener#sessionInit(com.vaadin.server.SessionInitEvent)
		 */
		@Override
		public void sessionInit(final SessionInitEvent event) throws ServiceException {
			/* Listen to requests so we can serve the custom "Browser too old" page */
			event.getSession().addRequestHandler(this);
		}

		/**
		 * @see com.vaadin.server.UnsupportedBrowserHandler#writeBrowserTooOldPage(com.vaadin.server.VaadinRequest, com.vaadin.server.VaadinResponse)
		 */
		@Override
		protected void writeBrowserTooOldPage(final VaadinRequest request, final VaadinResponse response) throws IOException {
			/* Récupère le nom du navigateur */
			final WebBrowser browser = Page.getCurrent().getWebBrowser();
			final StringBuilder browserSB = new StringBuilder(32);
			if (browser.isIE()) {
				browserSB.append("Internet Explorer");
			} else if (browser.isOpera()) {
				browserSB.append("Opera");
			} else if (browser.isFirefox()) {
				browserSB.append("Firefox");
			} else if (browser.isSafari()) {
				browserSB.append("Safari");
			} else {
				browserSB.append("[Navigateur inconnu]");
			}
			browserSB.append(" v").append(browser.getBrowserMajorVersion());

			/* Affiche le message d'erreur */
			response.setContentType("text/html");
			final Writer writer = response.getWriter();
			writer.write("<!DOCTYPE html>");
			writer.write("<html>");
			writer.write("<head>");
			writer.write("<meta charset=\"UTF-8\">");
			writer.write("<title>Navigateur non supporté</title>");
			writer.write("</head>");
			writer.write("<body>");
			writer.write("<p>" + browserSB.toString() + " n'est pas supporté. Veuillez mettre à jour votre navigateur.</p>");
			writer.write("</body>");
			writer.write("</html>");
		}
	}

	/**
	 * @see com.vaadin.server.VaadinServlet#servletInitialized()
	 */
	@Override
	protected final void servletInitialized() throws ServletException {
		super.servletInitialized();

		/* Listen to session init so we can serve our own unsupported page */
		getService().addSessionInitListener(new LocalizedUnsupportedBrowserHandler());
	}

}
