package fr.univlorraine.tools.vaadin;

import com.vaadin.ui.UI;

/**
 * Listener des événements sur les entités.
 * @author Adrien Colson
 * @param <ENTITY_TYPE> Type de l'entité suivie
 */
public interface EntityPushListener<ENTITY_TYPE> {

	/**
	 * Accède à l'UI concernée.
	 * @return UI concernée
	 */
	UI getUI();

	/**
	 * L'entité a été insérée en base.
	 * @param entity entité concernée
	 */
	void entityPersisted(ENTITY_TYPE entity);

	/**
	 * L'entité a été mise à jour en base.
	 * @param entity entité concernée
	 */
	void entityUpdated(ENTITY_TYPE entity);

	/**
	 * L'entité a été supprimée de la base.
	 * @param entity entité concernée
	 */
	void entityDeleted(ENTITY_TYPE entity);

}
