package fr.univlorraine.tools.vaadin;

import java.io.IOException;

import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.UI;

/**
 * FileDownloader affichant l'indicateur de chargement le temps de chargement de la ressource.
 * Le message warning affiché lors de la fermeture de l'indicateur de chargement peut être ignoré. (cf. http://dev.vaadin.com/ticket/12909)
 * @author Adrien Colson
 */
@SuppressWarnings("serial")
public class BusyIndicatorFileDownloader extends FileDownloader {

	/**
	 * Constructeur.
	 * @param resource ressource à télécharger
	 */
	public BusyIndicatorFileDownloader(final Resource resource) {
		super(resource);
	}

	/**
	 * Constructeur.
	 * @param resource ressource à télécharger
	 * @param target composant étendu
	 */
	public BusyIndicatorFileDownloader(final Resource resource, final AbstractComponent target) {
		super(resource);
		extend(target);
	}

	/**
	 * @see com.vaadin.server.FileDownloader#handleConnectorRequest(com.vaadin.server.VaadinRequest, com.vaadin.server.VaadinResponse, java.lang.String)
	 */
	@Override
	public boolean handleConnectorRequest(final VaadinRequest request, final VaadinResponse response, final String path) throws IOException {
		final BusyIndicatorWindow busyIndicatorWindow = new BusyIndicatorWindow();
		final UI ui = UI.getCurrent();
		ui.access(() -> ui.addWindow(busyIndicatorWindow));
		try {
			return super.handleConnectorRequest(request, response, path);
		} finally {
			busyIndicatorWindow.close();
		}
	}

}
