package fr.univlorraine.tools.servlet.listener;

import java.util.Enumeration;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * This ServletContextListener adds context init parameters to java system properties with prefix 'context.'.
 * @author Adrien Colson
 */
public class ContextParametersToSystemPropertiesListener implements ServletContextListener {

	/** 'context.' prefix. */
	private static final String CONTEXT_PREFIX = "context.";

	/**
	 * @see javax.servlet.ServletContextListener#contextInitialized(javax.servlet.ServletContextEvent)
	 */
	@Override
	public void contextInitialized(final ServletContextEvent servletContextEvent) {
		final ServletContext context = servletContextEvent.getServletContext();

		final Enumeration<String> parameterNamesEnum = context.getInitParameterNames();

		while (parameterNamesEnum.hasMoreElements()) {
			final String parameterName = parameterNamesEnum.nextElement();
			System.setProperty(CONTEXT_PREFIX + parameterName, context.getInitParameter(parameterName));
		}
	}

	/**
	 * @see javax.servlet.ServletContextListener#contextDestroyed(javax.servlet.ServletContextEvent)
	 */
	@Override
	public void contextDestroyed(final ServletContextEvent servletContextEvent) {
	}

}
