/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.vaadin;

import com.vaadin.annotations.JavaScript;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractJavaScriptExtension;
import com.vaadin.ui.UI;
import elemental.json.Json;
import elemental.json.JsonArray;
import fr.univlorraine.tools.vaadin.IAnalyticsTracker;

@JavaScript(value={"pwk_connector.js"})
public class PiwikAnalyticsTracker
extends AbstractJavaScriptExtension
implements IAnalyticsTracker {
    public PiwikAnalyticsTracker(UI targetUi, String trackerUrl, String siteId) {
        super.extend((AbstractClientConnector)targetUi);
        this.callFunction("setPiwikAccountCommand", new Object[]{trackerUrl, siteId});
    }

    private void pushCommand(Object ... commandAndArguments) {
        JsonArray ja = Json.createArray();
        for (int i = 0; i < commandAndArguments.length; ++i) {
            ja.set(i, String.valueOf(commandAndArguments[i]));
        }
        this.callFunction("pushCommand", new Object[]{ja});
    }

    @Override
    public void trackPageview(String name) {
        this.pushCommand("trackPageView", name);
    }

    @Override
    public void trackEvent(String category, String action) {
        this.pushCommand("trackEvent", category, action);
    }

    @Override
    public void trackEvent(String category, String action, String optLabel) {
        this.pushCommand("trackEvent", category, action, optLabel);
    }

    @Override
    public void trackEvent(String category, String action, String optLabel, Integer optValue) {
        this.pushCommand("trackEvent", category, action, optLabel, optValue);
    }

    @Override
    public void trackNavigator(Navigator navigator) {
        navigator.addViewChangeListener(new ViewChangeListener(){

            public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
                return true;
            }

            public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
                PiwikAnalyticsTracker.this.trackPageview(event.getViewName());
            }
        });
    }
}

