/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.logback;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class UserMdcServletFilter
implements Filter {
    public static final String USER_KEY = "username";

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean successfulRegistration = false;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof Authentication) {
            String username = auth.getName();
            successfulRegistration = this.registerUsername(username);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            if (successfulRegistration) {
                MDC.remove((String)USER_KEY);
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    private boolean registerUsername(String username) {
        if (username instanceof String && !username.isEmpty()) {
            MDC.put((String)USER_KEY, (String)username);
            return true;
        }
        return false;
    }
}

