/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.net.SMTPAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.helpers.CyclicBuffer;
import java.util.Calendar;
import java.util.Date;

public class TimeWindowSMTPAppender
extends SMTPAppender {
    private int timeWindowDurationSeconds = 1;
    private int maxMessagesPerTimeWindow = 1;
    private static int messagesCounter;
    private static Date currentStartTimeWindow;
    private Level logLevel = Level.ERROR;
    private Level cyclicBufferLogLevel = Level.TRACE;

    protected final void append(ILoggingEvent eventObject) {
        if (eventObject.getLevel().isGreaterOrEqual(this.logLevel) && this.isForLogged()) {
            super.append((Object)eventObject);
        } else if (eventObject.getLevel().isGreaterOrEqual(this.cyclicBufferLogLevel) && this.cbTracker != null) {
            String key = this.discriminator.getDiscriminatingValue((Object)eventObject);
            long now = System.currentTimeMillis();
            CyclicBuffer cb = (CyclicBuffer)this.cbTracker.getOrCreate(key, now);
            this.subAppend(cb, eventObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isForLogged() {
        TimeWindowSMTPAppender timeWindowSMTPAppender = this;
        synchronized (timeWindowSMTPAppender) {
            boolean isForLogged = false;
            Calendar currentEndTimeWindow = Calendar.getInstance();
            currentEndTimeWindow.setTime(currentStartTimeWindow);
            currentEndTimeWindow.add(13, this.timeWindowDurationSeconds);
            Date currentTime = new Date();
            if (messagesCounter < this.maxMessagesPerTimeWindow && currentTime.before(currentEndTimeWindow.getTime())) {
                isForLogged = true;
            } else if (currentTime.after(currentEndTimeWindow.getTime())) {
                messagesCounter = 0;
                currentStartTimeWindow = new Date();
                isForLogged = true;
            } else {
                isForLogged = false;
            }
            ++messagesCounter;
            return isForLogged;
        }
    }

    public int getTimeWindowDurationSeconds() {
        return this.timeWindowDurationSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeWindowDurationSeconds(int timeWindowDurationSecondsSet) {
        TimeWindowSMTPAppender timeWindowSMTPAppender = this;
        synchronized (timeWindowSMTPAppender) {
            this.timeWindowDurationSeconds = timeWindowDurationSecondsSet;
        }
    }

    public int getMaxMessagesPerTimeWindow() {
        return this.maxMessagesPerTimeWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxMessagesPerTimeWindow(int maxMessagesPerTimeWindowSet) {
        TimeWindowSMTPAppender timeWindowSMTPAppender = this;
        synchronized (timeWindowSMTPAppender) {
            this.maxMessagesPerTimeWindow = maxMessagesPerTimeWindowSet;
        }
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevelSet) {
        this.logLevel = Level.toLevel((String)logLevelSet);
    }

    public Level getCyclicBufferLogLevel() {
        return this.cyclicBufferLogLevel;
    }

    public void setCyclicBufferLogLevel(String cyclicBufferLogLevelSet) {
        this.cyclicBufferLogLevel = Level.toLevel((String)cyclicBufferLogLevelSet);
    }

    static {
        currentStartTimeWindow = new Date();
    }
}

