/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;

public class TimeFilter
extends Filter<ILoggingEvent> {
    private transient LocalTime startDisabling;
    private transient LocalTime stopDisabling;

    public FilterReply decide(ILoggingEvent event) {
        Instant eventInstant = Instant.ofEpochMilli(event.getTimeStamp());
        LocalTime eventTime = LocalTime.from(eventInstant.atZone(ZoneId.systemDefault()));
        if (this.startDisabling instanceof LocalTime && eventTime.isBefore(this.startDisabling)) {
            return FilterReply.NEUTRAL;
        }
        if (this.stopDisabling instanceof LocalTime && eventTime.isAfter(this.stopDisabling)) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public void setStartDisabling(String startDisablingSet) {
        this.startDisabling = LocalTime.parse(startDisablingSet);
    }

    public void setStopDisabling(String stopDisablingSet) {
        this.stopDisabling = LocalTime.parse(stopDisablingSet);
    }
}

