/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.tools.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.util.ContentTypeUtil;
import fr.univlorraine.tools.logback.GroupEventsSMTPAppender;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class GroupEventsFileSMTPAppender
extends GroupEventsSMTPAppender {
    public static final InternetAddress[] EMPTY_IA_ARRAY = new InternetAddress[0];
    public static final String UNDEFINED_SUBJECT = "Undefined subject";
    private Layout<ILoggingEvent> fileLayout;
    private String filename = "messages.csv";
    private String fileMimeType = "text/csv";
    private String fileCharset = "UTF-8";
    private String fileHeader;

    public Layout<ILoggingEvent> getFileLayout() {
        if (this.fileLayout == null) {
            PatternLayout defaultLayout = new PatternLayout();
            defaultLayout.setContext(this.context);
            defaultLayout.setPattern("%nopex%date;%level;%logger;%message%n");
            defaultLayout.start();
            this.fileLayout = defaultLayout;
        }
        return this.fileLayout;
    }

    public void setFileLayout(Layout<ILoggingEvent> fileLayoutSet) {
        this.fileLayout = fileLayoutSet;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filenameSet) {
        this.filename = filenameSet;
    }

    public String getFileMimeType() {
        return this.fileMimeType;
    }

    public void setFileMimeType(String fileMimeTypeSet) {
        this.fileMimeType = fileMimeTypeSet;
    }

    public String getFileCharset() {
        return this.fileCharset;
    }

    public void setFileCharset(String fileCharsetSet) {
        this.fileCharset = fileCharsetSet;
    }

    public String getFileHeader() {
        return this.fileHeader;
    }

    public void setFileHeader(String fileHeaderSet) {
        this.fileHeader = fileHeaderSet;
    }

    protected void sendBuffer(CyclicBuffer<ILoggingEvent> cb, ILoggingEvent lastEventObjectFired) {
        try {
            String footer;
            String presentationHeader;
            List<InternetAddress> destinationAddresses = this.parseAddress2(lastEventObjectFired);
            if (destinationAddresses.isEmpty()) {
                this.addInfo("Empty destination address. Aborting email transmission");
                return;
            }
            StringBuffer sbuf = new StringBuffer();
            String header = this.layout.getFileHeader();
            if (header instanceof String) {
                sbuf.append(header);
            }
            if ((presentationHeader = this.layout.getPresentationHeader()) instanceof String) {
                sbuf.append(presentationHeader);
            }
            byte[] fileBytes = this.fillBufferAndFile(cb, sbuf);
            String presentationFooter = this.layout.getPresentationFooter();
            if (presentationFooter instanceof String) {
                sbuf.append(presentationFooter);
            }
            if ((footer = this.layout.getFileFooter()) instanceof String) {
                sbuf.append(footer);
            }
            MimeMessage mimeMsg = new MimeMessage(this.session);
            if (this.getFrom() instanceof String) {
                mimeMsg.setFrom((Address)this.getAddress2(this.getFrom()));
            } else {
                mimeMsg.setFrom();
            }
            mimeMsg.setSubject(this.getMailSubject(lastEventObjectFired), this.getCharsetEncoding());
            Object[] toAddressArray = destinationAddresses.toArray(EMPTY_IA_ARRAY);
            mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])toAddressArray);
            String contentType = this.layout.getContentType();
            MimeBodyPart part = new MimeBodyPart();
            if (ContentTypeUtil.isTextual((String)contentType)) {
                part.setText(sbuf.toString(), this.getCharsetEncoding(), ContentTypeUtil.getSubType((String)contentType));
            } else {
                part.setContent((Object)sbuf.toString(), this.layout.getContentType());
            }
            MimeBodyPart csvPart = new MimeBodyPart();
            ByteArrayDataSource bads = new ByteArrayDataSource(fileBytes, this.getFileMimeType());
            csvPart.setDataHandler(new DataHandler((DataSource)bads));
            csvPart.setFileName(this.getFilename());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
            mp.addBodyPart((BodyPart)csvPart);
            mimeMsg.setContent((Multipart)mp);
            mimeMsg.setSentDate(new Date());
            this.addInfo("About to send out SMTP message \"" + mimeMsg.getSubject() + "\" to " + Arrays.toString(toAddressArray));
            Transport.send((Message)mimeMsg);
        }
        catch (MessagingException me) {
            this.addError("Error occurred while sending e-mail notification.", me);
        }
    }

    private String getMailSubject(ILoggingEvent lastEventObjectFired) {
        if (this.subjectLayout instanceof Layout) {
            return this.subjectLayout.doLayout((Object)lastEventObjectFired).split("\\r?\\n")[0];
        }
        return UNDEFINED_SUBJECT;
    }

    protected byte[] fillBufferAndFile(CyclicBuffer<ILoggingEvent> cb, StringBuffer sbuf) {
        StringBuffer sb = new StringBuffer();
        if (this.getFileHeader() instanceof String) {
            sb.append(this.getFileHeader());
            sb.append(System.lineSeparator());
        }
        int len = cb.length();
        for (int i = 0; i < len; ++i) {
            ILoggingEvent event = (ILoggingEvent)cb.get();
            sbuf.append(this.layout.doLayout((Object)event));
            sb.append(this.getFileLayout().doLayout((Object)event));
        }
        return String.valueOf(sb).getBytes(Charset.forName(this.getFileCharset()));
    }

    private InternetAddress getAddress2(String addressStr) {
        try {
            return new InternetAddress(addressStr);
        }
        catch (AddressException e) {
            this.addError("Could not parse address [" + addressStr + "].", e);
            return null;
        }
    }

    private List<InternetAddress> parseAddress2(ILoggingEvent event) {
        int len = this.getToList().size();
        ArrayList<InternetAddress> iaList = new ArrayList<InternetAddress>();
        for (int i = 0; i < len; ++i) {
            try {
                PatternLayoutBase emailPL = (PatternLayoutBase)this.getToList().get(i);
                String emailAdrr = emailPL.doLayout((Object)event);
                if (emailAdrr == null || emailAdrr.length() == 0) continue;
                InternetAddress[] tmp = InternetAddress.parse((String)emailAdrr, (boolean)true);
                iaList.addAll(Arrays.asList(tmp));
                continue;
            }
            catch (AddressException e) {
                this.addError("Could not parse email address for [" + this.getToList().get(i) + "] for event [" + event + "]", e);
                return iaList;
            }
        }
        return iaList;
    }
}

