package fr.univlorraine.tools.vaadin;

import ru.xpoft.vaadin.SpringApplicationContext;
import ru.xpoft.vaadin.VaadinView;
import ru.xpoft.vaadin.ViewCacheContainer;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewProvider;

/**
 * Error view provider which creates new view instances based on a view class.
 * @author Adrien Colson
 */
@SuppressWarnings("serial")
public class SpringErrorViewProvider implements ViewProvider {

	/** Nom du bean de la vue. */
	private final String beanName;
	/** Vue d'erreur. */
	private final VaadinView vaadinView;
	/** Cache des vues. */
	private final ViewCacheContainer cacheContainer;

	/**
	 * @param viewClass class to instantiate when a view is requested (not null)
	 * @param cacheContainerSet views cache container (not null)
	 */
	public SpringErrorViewProvider(final Class<? extends View> viewClass, final ViewCacheContainer cacheContainerSet) {
		if (viewClass == null || cacheContainerSet == null) {
			throw new IllegalArgumentException("viewClass and cacheContainer must be non-null");
		}

		if (!View.class.isAssignableFrom(viewClass)) {
			throw new IllegalArgumentException("viewClass must extend View");
		}

		if (!viewClass.isAnnotationPresent(VaadinView.class)) {
			throw new IllegalArgumentException("viewClass must have @VaadinView annotation");
		}

		final String[] beanNames = SpringApplicationContext.getApplicationContext().getBeanNamesForType(viewClass);
		if (beanNames.length != 1) {
			throw new IllegalArgumentException("cant't resolve bean name for class: " + viewClass.getName());
		}
		beanName = beanNames[0];

		vaadinView = viewClass.getAnnotation(VaadinView.class);

		this.cacheContainer = cacheContainerSet;
	}

	/**
	 * @see com.vaadin.navigator.ViewProvider#getViewName(java.lang.String)
	 */
	@Override
	public String getViewName(final String viewAndParameters) {
		return vaadinView.value();
	}

	/**
	 * @see com.vaadin.navigator.ViewProvider#getView(java.lang.String)
	 */
	@Override
	public View getView(final String viewName) {
		return cacheContainer.getView(vaadinView.value(), beanName, vaadinView.cached());
	}

}
