package fr.univlorraine.tools.vaadin;

import java.io.IOException;
import java.io.ObjectInputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewChangeListener;

/**
 * IAnalyticsTracker utilisant un logger.
 * @author Adrien Colson
 */
@SuppressWarnings("serial")
public class LogAnalyticsTracker implements IAnalyticsTracker {

	/**
	 * Logger de classe.
	 */
	private transient Logger logger = LoggerFactory.getLogger(LogAnalyticsTracker.class);

	/**
	 * Initialise les champs transient.
	 * @see java.io.ObjectInputStream#defaultReadObject()
	 * @param inputStream deserializes primitive data and objects previously written using an ObjectOutputStream.
	 * @throws IOException if an I/O error occurs.
	 * @throws ClassNotFoundException if the class of a serialized object could not be found.
	 */
	private void readObject(final ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
		inputStream.defaultReadObject();
		logger = LoggerFactory.getLogger(LogAnalyticsTracker.class);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.IAnalyticsTracker#trackPageview(java.lang.String)
	 */
	@Override
	public void trackPageview(final String name) {
		logger.debug("trackPageView({})", name);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.IAnalyticsTracker#trackEvent(java.lang.String, java.lang.String)
	 */
	@Override
	public void trackEvent(final String category, final String action) {
		logger.debug("trackEvent({}, {})", category, action);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.IAnalyticsTracker#trackEvent(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public void trackEvent(final String category, final String action, final String optLabel) {
		logger.debug("trackEvent({}, {}, {})", category, action, optLabel);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.IAnalyticsTracker#trackEvent(java.lang.String, java.lang.String, java.lang.String, java.lang.Integer)
	 */
	@Override
	public void trackEvent(final String category, final String action, final String optLabel, final Integer optValue) {
		logger.debug("trackEvent({}, {}, {}, {})", category, action, optLabel, optValue);
	}

	/**
	 * @see fr.univlorraine.tools.vaadin.IAnalyticsTracker#trackNavigator(com.vaadin.navigator.Navigator)
	 */
	@Override
	public void trackNavigator(final Navigator navigator) {
		navigator.addViewChangeListener(new ViewChangeListener() {
			/**
			 * @see com.vaadin.navigator.ViewChangeListener#beforeViewChange(com.vaadin.navigator.ViewChangeListener.ViewChangeEvent)
			 */
			@Override
			public boolean beforeViewChange(final ViewChangeEvent event) {
				return true;
			}

			/**
			 * @see com.vaadin.navigator.ViewChangeListener#afterViewChange(com.vaadin.navigator.ViewChangeListener.ViewChangeEvent)
			 */
			@Override
			public void afterViewChange(final ViewChangeEvent event) {
				trackPageview(event.getViewName());
			}
		});
	}

}
