package fr.univlorraine.tools.vaadin;

import com.vaadin.data.util.AbstractBeanContainer.BeanIdResolver;

/**
 * BeanIdResolver utilisant l'identityHashCode du bean, à utiliser avec les BeanContainer.
 * @author Adrien Colson
 * @param <BEANTYPE> type du bean
 */
@SuppressWarnings("serial")
public class IdentityBeanIdResolver<BEANTYPE> implements BeanIdResolver<Integer, BEANTYPE> {

	/**
	 * @see com.vaadin.data.util.AbstractBeanContainer.BeanIdResolver#getIdForBean(java.lang.Object)
	 */
	@Override
	public Integer getIdForBean(final BEANTYPE bean) {
		return System.identityHashCode(bean);
	}

}
