/*
 * Decompiled with CFR 0.152.
 */
package fr.univnancy2.PhotoClient.tools;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;

public final class OutilsImage {
    private OutilsImage() {
    }

    public static BufferedImage getBufferedImage(Image img) {
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(img, null, null);
        return bi;
    }

    public static BufferedImage loadImage(File fichier) {
        BufferedImage bim = null;
        try {
            FileImageInputStream fis = new FileImageInputStream(fichier);
            bim = ImageIO.read(fis);
        }
        catch (IOException exc) {
            System.out.println("Erreur lors de la lecture de l'image :" + exc);
        }
        return bim;
    }

    public static boolean saveImage(BufferedImage image, File file, String type) {
        boolean ok = true;
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(type);
        if (it.hasNext()) {
            ImageWriter iw = it.next();
            try {
                FileImageOutputStream fios = new FileImageOutputStream(file);
                iw.setOutput(fios);
                try {
                    iw.write(image);
                }
                catch (IllegalArgumentException iae) {
                    System.err.println("Un probl\u00e8me s'est produit \u00e0 l'\u00e9criture de l'image : " + iae);
                    ok = false;
                }
                fios.flush();
                fios.close();
                iw.dispose();
            }
            catch (IOException e) {
                System.err.println("Erreur E/S lors de l'\u00e9criture dans le fichier : " + e);
                ok = false;
            }
        } else {
            System.out.println("Impossible de trouver un \u00e9crivain pour le format " + type + " demand\u00e9");
            ok = false;
        }
        return ok;
    }
}

