/*
 * Decompiled with CFR 0.152.
 */
package fr.univnancy2.PhotoClient.gui;

import fr.univnancy2.PhotoClient.beans.Category;
import fr.univnancy2.PhotoClient.beans.ISimpleLogger;
import fr.univnancy2.PhotoClient.beans.PhotoClient;
import fr.univnancy2.PhotoClient.beans.TicketClient;
import fr.univnancy2.PhotoClient.exception.PhotoClientException;
import fr.univnancy2.PhotoClient.gui.ImageCapturePanel;
import fr.univnancy2.PhotoClient.gui.ImagePanel;
import fr.univnancy2.PhotoClient.gui.ImageStore;
import fr.univnancy2.PhotoClient.tools.OutilsImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PhotoClientGUI
extends JPanel
implements ActionListener,
ISimpleLogger,
ImageStore {
    private static final long serialVersionUID = 1L;
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final int DELAI_TICKET_SEC = 60;
    private ImagePanel panneauImage;
    private Map<String, String> serverUrl = new HashMap<String, String>();
    private String ticketURL = null;
    private String ressourceURL = null;
    private String ressourceLoginURL = null;
    private JTextField tfIdenfitiant;
    private JTextArea com;
    private TicketClient tc;
    private JTextField tfTypLim;
    private JTextField tfValLim;
    private JComboBox cbPriv;
    private JComboBox cbServer;
    private JCheckBox cbLog;
    private JComboBox cbCatNames;
    private JLabel labImage;
    private PhotoClient photoClient;
    JFrame captureFrame = null;
    boolean webCam = false;
    public int imgNum = 0;
    private JRadioButton rbCode;
    private JRadioButton rbLogin;
    private JTextField tfLogName;

    public PhotoClientGUI(JFrame ownerFrame) {
        this.configurePhotoClient();
        this.tc = null;
        this.setLayout(new BorderLayout());
        this.panneauImage = new ImagePanel(ownerFrame, new Dimension(200, 200));
        JPanel panneauImageCentrage = new JPanel(new GridBagLayout());
        panneauImageCentrage.add((Component)this.panneauImage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 10, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)panneauImageCentrage, "Center");
        JPanel serverPanel = new JPanel();
        serverPanel.add(new JLabel("Serveur de photos"));
        this.cbServer = new JComboBox<Object>(this.serverUrl.keySet().toArray());
        serverPanel.add(this.cbServer);
        this.cbServer.addActionListener(this);
        this.cbServer.setActionCommand("CHANGE_SERVER");
        this.selectServer();
        JPanel ticketPanel = new JPanel();
        ticketPanel.add(new JLabel("Ticket"));
        String[] priv = new String[]{"Normal", "Privil\u00e9gi\u00e9"};
        this.cbPriv = new JComboBox<String>(priv);
        ticketPanel.add(this.cbPriv);
        ticketPanel.add(new JLabel("Login utilisateur"));
        this.tfLogName = new JTextField("dummy", 10);
        ticketPanel.add(this.tfLogName);
        this.createButton("Nouveau ticket", "Demande un nouveau ticket sur le serveur", "getTicket", this, ticketPanel, true);
        ticketPanel.add(new JLabel("Type lim"));
        this.tfTypLim = new JTextField("", 8);
        ticketPanel.add(this.tfTypLim);
        ticketPanel.add(new JLabel("Val lim"));
        this.tfValLim = new JTextField("", 10);
        ticketPanel.add(this.tfValLim);
        JPanel ressourcePanel = new JPanel();
        ressourcePanel.add(new JLabel("Ressource"));
        ressourcePanel.add(new JLabel("Cat\u00e9gorie :"));
        String[] catNames = new String[]{"Etudiant", "Personnel"};
        this.cbCatNames = new JComboBox<String>(catNames);
        ressourcePanel.add(this.cbCatNames);
        ressourcePanel.add(new JLabel("Identifiant :"));
        this.tfIdenfitiant = new JTextField("", 9);
        ressourcePanel.add(this.tfIdenfitiant);
        this.rbCode = new JRadioButton("par code");
        this.rbCode.setSelected(true);
        ressourcePanel.add(this.rbCode);
        this.rbLogin = new JRadioButton("par login");
        ressourcePanel.add(this.rbLogin);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbCode);
        group.add(this.rbLogin);
        this.createButton("GET", "Demande de photo", "GET", this, ressourcePanel, true);
        this.createButton("PUT", "D\u00e9p\u00f4t de photo", "PUT", this, ressourcePanel, true);
        this.createButton("DELETE", "Suppression de photo", "DELETE", this, ressourcePanel, true);
        JPanel localImagePanel = new JPanel();
        this.labImage = new JLabel("Image locale");
        localImagePanel.add(this.labImage);
        this.createButton("Charger", "Ouvre une image locale", "loadLocalImage", this, localImagePanel, true);
        this.createButton("Sauver", "Sauve une image locale", "saveLocalImage", this, localImagePanel, true);
        this.createButton("Capturer", "Capture d'image", "WebCam", this, localImagePanel, this.webCam);
        this.createButton("Recadrer", "Recadre l'image courante", "Cadrage", this, localImagePanel, true);
        this.createButton("Image pr\u00e9c\u00e9dente", "Annule les modifications", "Revert", this, localImagePanel, true);
        JPanel miscPanel = new JPanel();
        this.cbLog = new JCheckBox("Tracage", true);
        miscPanel.add(this.cbLog);
        JPanel cmdPanel = new JPanel();
        cmdPanel.setLayout(new GridLayout(5, 1));
        cmdPanel.add(serverPanel);
        cmdPanel.add(ticketPanel);
        cmdPanel.add(ressourcePanel);
        cmdPanel.add(localImagePanel);
        cmdPanel.add(miscPanel);
        this.add((Component)cmdPanel, "North");
        this.com = new JTextArea(10, 40);
        this.add((Component)new JScrollPane(this.com, 20, 30), "South");
        try {
            if (this.webCam) {
                this.captureFrame = new JFrame("Capture d'image");
                ImageCapturePanel cf = ImageCapturePanel.getInstance(this.captureFrame, this);
                this.captureFrame.setContentPane(cf);
                this.captureFrame.pack();
                this.captureFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent e) {
                        ImageCapturePanel.playerclose();
                    }
                });
            }
        }
        catch (InstantiationException ex) {
            this.error("Pas de p\u00e9riph\u00e9rique de capture vid\u00e9o (VFW) disponible.");
            System.err.println("Aucun p\u00e9riph\u00e9rique VFW trouv\u00e9: " + ex);
            this.webCam = false;
            this.captureFrame = null;
        }
        catch (NoClassDefFoundError ex) {
            this.error("Pas de support Java Media Framework disponible.");
            System.err.println("Classe introuvable : " + ex);
            this.webCam = false;
            this.captureFrame = null;
        }
    }

    public JButton createButton(String caption, String desc, String actionCommand, ActionListener alistener, Container cont, boolean enabled) {
        JButton bt = new JButton(caption);
        bt.setToolTipText(desc);
        bt.addActionListener(alistener);
        bt.setActionCommand(actionCommand);
        bt.setEnabled(enabled);
        cont.add(bt);
        return bt;
    }

    private void configurePhotoClient() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserEx) {
            System.err.println("Erreur fatale : impossible d'obtenir un analyseur XML : " + parserEx);
            System.exit(-1);
        }
        Document doc = null;
        try {
            doc = builder.parse("properties/PhotoConfig.xml");
        }
        catch (SAXException e) {
            System.err.println("Erreur fatale : Echec lors de l'analyse du fichier de configuration : " + e);
            System.exit(-1);
        }
        catch (IOException e) {
            System.err.println("Erreur fatale : Echec lors la lecture du fichier de configuration : " + e);
            System.exit(-1);
        }
        try {
            Element root = doc.getDocumentElement();
            NodeList nl = root.getElementsByTagName("server");
            Element serveurElt = null;
            int i = 0;
            while (i < nl.getLength()) {
                serveurElt = (Element)nl.item(i);
                this.serverUrl.put(serveurElt.getAttribute("name"), serveurElt.getTextContent());
                ++i;
            }
            this.ticketURL = root.getElementsByTagName("ticket-url").item(0).getTextContent();
            this.ressourceURL = root.getElementsByTagName("ressource-url").item(0).getTextContent();
            this.ressourceLoginURL = root.getElementsByTagName("ressource-login-url").item(0).getTextContent();
            NodeList webCams = root.getElementsByTagName("webcam");
            if (webCams.getLength() > 0) {
                this.webCam = ((Element)webCams.item(0)).getAttribute("active").equals("Y");
            } else {
                System.out.println("Pas de webcam configur\u00e9e");
            }
            String codeApp = root.getElementsByTagName("code-photo-app").item(0).getTextContent();
            this.photoClient = new PhotoClient(this);
            this.photoClient.setApplicationCode(codeApp);
        }
        catch (Exception e) {
            System.err.println("Erreur fatale : Configuration incorrecte : " + e);
            System.exit(-1);
        }
    }

    public void selectServer() {
        String selectedServer = (String)this.cbServer.getSelectedItem();
        this.photoClient.setTicketURLPattern(String.valueOf(this.serverUrl.get(selectedServer)) + this.ticketURL);
        this.photoClient.setRessourceURLPattern(String.valueOf(this.serverUrl.get(selectedServer)) + this.ressourceURL);
        this.photoClient.setRessourceByLoginURLPattern(String.valueOf(this.serverUrl.get(selectedServer)) + this.ressourceLoginURL);
    }

    public void actionPerformed(ActionEvent e) {
        block57: {
            String commande = e.getActionCommand();
            if (commande.equals("CHANGE_SERVER")) {
                this.selectServer();
            } else if (commande.equals("getTicket")) {
                try {
                    this.tc = this.photoClient.getTicket(this.cbPriv.getSelectedIndex(), this.tfTypLim.getText(), this.tfValLim.getText(), this.tfLogName.getText());
                    this.com.append(this.tc.toString());
                }
                catch (PhotoClientException e1) {
                    this.error("Impossible d'obtenir un ticket. Cause " + e1);
                }
            } else if (commande.equals("WebCam")) {
                if (this.webCam) {
                    this.captureFrame.setVisible(true);
                }
            } else if (commande.equals("Cadrage")) {
                this.panneauImage.cadrage();
                this.labImage.setText(this.panneauImage.describeImage());
            } else if (commande.equals("Revert")) {
                this.panneauImage.revertImage();
                this.labImage.setText(this.panneauImage.describeImage());
            } else if (commande.equals("loadLocalImage")) {
                JFileChooser chooser = new JFileChooser(".");
                int resultat = chooser.showOpenDialog(this);
                if (resultat == 0) {
                    this.setImage(OutilsImage.loadImage(chooser.getSelectedFile()));
                }
            } else if (commande.equals("saveLocalImage")) {
                if (this.panneauImage.hasImage()) {
                    boolean res;
                    JFileChooser chooser = new JFileChooser(".");
                    int resultat = chooser.showSaveDialog(this);
                    if (resultat == 0 && !(res = OutilsImage.saveImage(this.panneauImage.getCurrentImage(), chooser.getSelectedFile(), "JPG"))) {
                        JOptionPane.showMessageDialog(null, "Une erreur s'est produite pendant la sauvegarde du fichier", "Erreur", 0);
                    }
                } else {
                    this.error("Il n'y a pas d'image \u00e0 sauver.");
                }
            } else if (commande.equals("GET")) {
                String identifiantRessource = this.tfIdenfitiant.getText();
                if (!identifiantRessource.equals("")) {
                    if (this.tc != null && this.tc.isValid(60)) {
                        try {
                            int selCat = this.cbCatNames.getSelectedIndex();
                            BufferedImage img = null;
                            if (this.rbCode.isSelected()) {
                                img = this.photoClient.getPhotoImage(Category.values()[selCat], identifiantRessource, this.tc);
                            } else if (this.rbLogin.isSelected()) {
                                img = this.photoClient.getPhotoImageByLogin(Category.values()[selCat], identifiantRessource, this.tc);
                            } else {
                                this.error("Type d'identifiant non choisi.");
                            }
                            if (img != null) {
                                this.setImage(img);
                                break block57;
                            }
                            this.error("La photo n'existe pas.");
                        }
                        catch (PhotoClientException e1) {
                            this.error("Exception lors de la r\u00e9cup\u00e9ration de la photo :" + e1);
                        }
                    } else {
                        this.error("Il n'y a pas de ticket valide.");
                    }
                } else {
                    this.error("Identifiant de ressource absent.");
                }
            } else if (commande.equals("PUT")) {
                String identifiantRessource = this.tfIdenfitiant.getText();
                if (!identifiantRessource.equals("")) {
                    BufferedImage img = this.panneauImage.getCurrentImage();
                    if (img != null) {
                        if (this.tc != null && this.tc.isValid(60)) {
                            try {
                                int selCat = this.cbCatNames.getSelectedIndex();
                                if (this.rbCode.isSelected()) {
                                    this.photoClient.putPhoto(Category.values()[selCat], identifiantRessource, img, this.tc);
                                    break block57;
                                }
                                if (this.rbLogin.isSelected()) {
                                    this.photoClient.putPhotoByLogin(Category.values()[selCat], identifiantRessource, img, this.tc);
                                    break block57;
                                }
                                this.error("Type d'identifiant non choisi.");
                            }
                            catch (PhotoClientException e1) {
                                this.error("PhotoClientException " + e1);
                            }
                        } else {
                            this.error("Il n'y a pas de ticket.");
                        }
                    } else {
                        this.error("Il n'y a pas d'image \u00e0 d\u00e9poser.");
                    }
                } else {
                    this.error("Identifiant de ressource absent.");
                }
            } else if (commande.equals("DELETE")) {
                String identifiantRessource = this.tfIdenfitiant.getText();
                if (!identifiantRessource.equals("")) {
                    int res = JOptionPane.showConfirmDialog(this, "Voulez-vous vraiment supprimer la photo " + identifiantRessource, "Confirmation", 0);
                    if (res == 0) {
                        if (this.tc != null && this.tc.isValid(60)) {
                            try {
                                int selCat = this.cbCatNames.getSelectedIndex();
                                if (this.rbCode.isSelected()) {
                                    this.photoClient.deletePhoto(Category.values()[selCat], identifiantRessource, this.tc);
                                    break block57;
                                }
                                if (this.rbLogin.isSelected()) {
                                    this.photoClient.deletePhotoByLogin(Category.values()[selCat], identifiantRessource, this.tc);
                                    break block57;
                                }
                                this.error("Type d'identifiant non choisi.");
                            }
                            catch (PhotoClientException e2) {
                                this.error("Erreur lors de la suppression " + e2);
                            }
                        } else {
                            this.error("Il n'y a pas de ticket.");
                        }
                    } else {
                        this.error("L'effacement a \u00e9t\u00e9 annul\u00e9.");
                    }
                } else {
                    this.error("Identifiant de ressource absent.");
                }
            }
        }
    }

    public void error(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Erreur", 0);
    }

    public void setImage(BufferedImage img) {
        this.panneauImage.setImage(img);
        this.labImage.setText(this.panneauImage.describeImage());
    }

    public void notify(int niveau, String message) {
        if (this.cbLog.isSelected()) {
            if (niveau == 0) {
                this.com.append("ERREUR - " + message);
                this.com.append(NEW_LINE);
            } else if (niveau == 1) {
                this.com.append("INFO - " + message);
                this.com.append(NEW_LINE);
            } else {
                this.com.append("DEBUG - " + message);
                this.com.append(NEW_LINE);
            }
        }
    }

    public static void main(String[] args) {
        JFrame mainFrame = new JFrame("Simple client pour le Serveur de Photos");
        PhotoClientGUI cf = new PhotoClientGUI(mainFrame);
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setContentPane(cf);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

