/*
 * Decompiled with CFR 0.152.
 */
package fr.univnancy2.PhotoClient.gui;

import fr.univnancy2.PhotoClient.tools.OutilsImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

class ImagePanel
extends JPanel
implements MouseInputListener {
    private static final long serialVersionUID = -6625531560072006923L;
    private BufferedImage currentImage = null;
    private BufferedImage previousImage = null;
    private JFrame owner;
    private Rectangle selection;

    public ImagePanel(JFrame ownerFrame, Dimension dims) {
        this.setLayout(null);
        this.setPreferredSize(dims);
        this.owner = ownerFrame;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.selection = new Rectangle();
        this.currentImage = null;
        this.previousImage = null;
    }

    public void setImage(BufferedImage img) {
        this.previousImage = this.currentImage;
        this.currentImage = img;
        int w = 0;
        int h = 0;
        if (img != null) {
            w = img.getWidth(null);
            h = img.getHeight(null);
            Dimension dims = this.getPreferredSize();
            if ((double)w != dims.getWidth() || (double)h != dims.getHeight()) {
                this.setPreferredSize(new Dimension(w, h));
            }
        }
        this.selection.x = 0;
        this.selection.y = 0;
        this.selection.width = w;
        this.selection.height = h;
        this.owner.pack();
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.currentImage != null) {
            g.drawImage(this.currentImage, 0, 0, this);
            g.setColor(Color.RED);
            g.drawRect(this.selection.x, this.selection.y, this.selection.width, this.selection.height);
        } else {
            g.setColor(Color.DARK_GRAY);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.WHITE);
            g.drawString("Pas d'image", 50, 50);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.selection.x = evt.getX();
        this.selection.y = evt.getY();
        Dimension dims = this.getPreferredSize();
        if ((double)(this.selection.x + this.selection.width) > dims.getWidth()) {
            this.selection.width = (int)dims.getWidth() - this.selection.x;
            this.selection.height = (int)((double)this.selection.width / 3.0 * 4.0);
        }
        if ((double)(this.selection.y + this.selection.height) > dims.getHeight()) {
            this.selection.height = (int)dims.getHeight() - this.selection.y;
            this.selection.width = (int)((double)this.selection.height / 4.0 * 3.0);
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        Dimension dims = this.getPreferredSize();
        int nx = evt.getX();
        if ((double)nx <= dims.getWidth()) {
            this.selection.width = nx - this.selection.x;
            this.selection.height = (int)((double)this.selection.width / 3.0 * 4.0);
            if ((double)(this.selection.y + this.selection.height) > dims.getHeight()) {
                this.selection.height = (int)dims.getHeight() - this.selection.y;
                this.selection.width = (int)((double)this.selection.height / 4.0 * 3.0);
            }
            this.repaint();
        } else {
            System.out.println("out");
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void cadrage() {
        if (this.currentImage != null && this.selection.width > 0 && this.selection.height > 0) {
            BufferedImage zoomed = this.currentImage.getSubimage(this.selection.x, this.selection.y, this.selection.width, this.selection.height);
            Image scaled = zoomed.getScaledInstance(240, 320, 4);
            this.setImage(OutilsImage.getBufferedImage(scaled));
        }
    }

    public boolean hasImage() {
        return this.currentImage != null;
    }

    public BufferedImage getCurrentImage() {
        return this.currentImage;
    }

    public void revertImage() {
        if (this.previousImage != null) {
            this.setImage(this.previousImage);
            this.previousImage = null;
        }
    }

    public String describeImage() {
        if (this.currentImage == null) {
            return "Pas d'image locale";
        }
        StringBuffer imageDesc = new StringBuffer();
        imageDesc.append("Image locale (");
        imageDesc.append(this.currentImage.getWidth());
        imageDesc.append("x");
        imageDesc.append(this.currentImage.getHeight());
        imageDesc.append(")");
        return imageDesc.toString();
    }
}

