/*
 * Decompiled with CFR 0.152.
 */
package fr.univnancy2.PhotoClient.gui;

import fr.univnancy2.PhotoClient.gui.ImageStore;
import fr.univnancy2.PhotoClient.tools.OutilsImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.util.BufferToImage;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class ImageCapturePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -852713725952374528L;
    private DataSource dataSource = null;
    private Component playerComp = null;
    private static Player player = null;
    private JButton capture = null;
    private ImageStore imageStore = null;
    private Format[] availableVideoFormats;
    private String[] availableFormatDesc;
    private JComboBox cbFormat;
    private VideoFormat requestedVF = null;
    private JFrame container;
    private static ImageCapturePanel singleton = null;

    private ImageCapturePanel(JFrame containerFrame, ImageStore store) throws InstantiationException {
        this.container = containerFrame;
        this.imageStore = store;
        CaptureDeviceInfo devInfo = null;
        this.setLayout(new BorderLayout());
        this.capture = new JButton("Capture");
        this.capture.setActionCommand("Capture");
        this.capture.addActionListener(this);
        Vector v = CaptureDeviceManager.getDeviceList(null);
        int i = 0;
        while (i < v.size()) {
            CaptureDeviceInfo cdi = (CaptureDeviceInfo)v.elementAt(i);
            String deviceName = cdi.getName();
            if (deviceName.startsWith("vfw:")) {
                devInfo = CaptureDeviceManager.getDevice((String)deviceName);
                break;
            }
            ++i;
        }
        if (devInfo == null) {
            throw new InstantiationException("Impossible de trouver un p\u00e9riph\u00e9rique Vid\u00e9o For Windows.");
        }
        this.availableVideoFormats = devInfo.getFormats();
        double bestHei = 0.0;
        double bestWid = 0.0;
        this.availableFormatDesc = new String[this.availableVideoFormats.length];
        int fi = 0;
        while (fi < this.availableVideoFormats.length) {
            VideoFormat vf = (VideoFormat)this.availableVideoFormats[fi];
            Dimension di = vf.getSize();
            this.availableFormatDesc[fi] = String.valueOf(vf.getEncoding()) + " " + di.getWidth() + "x" + di.getHeight();
            if (vf instanceof RGBFormat && ((double)di.height > bestHei || di.getWidth() > bestWid)) {
                this.requestedVF = vf;
                bestHei = di.getHeight();
                bestWid = di.getWidth();
            }
            ++fi;
        }
        MediaLocator mediaLoc = devInfo.getLocator();
        try {
            this.dataSource = Manager.createDataSource((MediaLocator)mediaLoc);
            FormatControl[] formatControls = ((CaptureDevice)this.dataSource).getFormatControls();
            formatControls[0].setFormat((Format)this.requestedVF);
            player = Manager.createRealizedPlayer((DataSource)this.dataSource);
            player.start();
            this.playerComp = player.getVisualComponent();
            if (this.playerComp == null) {
                throw new InstantiationException("Impossible de r\u00e9cup\u00e9rer le composant visuel pour la vid\u00e9o.");
            }
            this.add(this.playerComp, "North");
            Component comp2 = player.getControlPanelComponent();
            if (comp2 == null) {
                throw new InstantiationException("Impossible de r\u00e9cup\u00e9rer le composant de param\u00e9trage pour la vid\u00e9o.");
            }
            this.add(comp2, "West");
            this.add((Component)this.capture, "Center");
            this.cbFormat = new JComboBox<String>(this.availableFormatDesc);
            this.add((Component)this.cbFormat, "West");
            this.cbFormat.setActionCommand("Change Format");
            this.cbFormat.addActionListener(this);
        }
        catch (Exception e) {
            throw new InstantiationException("Erreur " + e);
        }
    }

    public static synchronized ImageCapturePanel getInstance(JFrame containerFrame, ImageStore store) throws InstantiationException {
        if (singleton == null) {
            singleton = new ImageCapturePanel(containerFrame, store);
        }
        return singleton;
    }

    public static synchronized void playerclose() {
        if (player != null) {
            player.close();
            player.deallocate();
            System.out.println("Player ferm\u00e9.");
            player = null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Capture")) {
            FrameGrabbingControl fgc = (FrameGrabbingControl)player.getControl("javax.media.control.FrameGrabbingControl");
            Buffer buf = fgc.grabFrame();
            BufferToImage btoi = new BufferToImage((VideoFormat)buf.getFormat());
            BufferedImage img = OutilsImage.getBufferedImage(btoi.createImage(buf));
            this.imageStore.setImage(img);
            this.container.setVisible(false);
        } else if (cmd.equals("Change Format")) {
            player.stop();
            int reqIdx = this.cbFormat.getSelectedIndex();
            this.requestedVF = (VideoFormat)this.availableVideoFormats[reqIdx];
            FormatControl[] formatControls = ((CaptureDevice)this.dataSource).getFormatControls();
            formatControls[0].setFormat((Format)this.requestedVF);
            this.container.pack();
            player.start();
        }
    }
}

