/*
 * Decompiled with CFR 0.152.
 */
package fr.univnancy2.PhotoClient.dao;

import fr.univnancy2.PhotoClient.beans.ISimpleLogger;
import fr.univnancy2.PhotoClient.beans.TicketClient;
import fr.univnancy2.PhotoClient.exception.PhotoClientException;
import fr.univnancy2.PhotoClient.exception.TicketException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WebServiceClient {
    private ISimpleLogger logger = null;

    public WebServiceClient(ISimpleLogger log) {
        this.logger = log;
    }

    protected final void dumpHeaders(HttpURLConnection conn) {
        for (Map.Entry<String, List<String>> me : conn.getHeaderFields().entrySet()) {
            String s = String.valueOf(me.getKey()) + " = ";
            for (String val : me.getValue()) {
                s = String.valueOf(s) + val + " ";
            }
            this.message(1, s);
        }
    }

    private void message(int niveau, String msg) {
        if (this.logger != null) {
            this.logger.notify(niveau, msg);
        }
    }

    public Object getPhoto(String url, String type) throws PhotoClientException {
        PhotoClientException pex = null;
        Object resultat = null;
        HttpURLConnection conn = this.openConnexion(url, "GET");
        if (conn == null) {
            throw new PhotoClientException("Impossible d'\u00e9tablir la connexion au serveur de photos.");
        }
        try {
            int codeReponse = conn.getResponseCode();
            if (codeReponse == 200) {
                InputStream is = conn.getInputStream();
                if (type.equals("BufferedImage")) {
                    resultat = ImageIO.read(is);
                } else if (type.equals("byte[]")) {
                    int nbLu;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] data = new byte[4096];
                    while ((nbLu = is.read(data)) != -1) {
                        baos.write(data, 0, nbLu);
                    }
                    baos.flush();
                    baos.close();
                    resultat = baos.toByteArray();
                } else {
                    this.message(0, "getPhoto - Type de resultat demand\u00e9 non gere " + type);
                    resultat = null;
                }
                is.close();
                if (resultat != null) {
                    this.message(2, "getPhoto - La recuperation d'une photo s'est terminee avec succes.");
                } else {
                    this.message(0, "Probleme interne - Impossible de traiter la photo recuperee.");
                    pex = new PhotoClientException("Probl\u00e8me interne - Impossible de traiter la photo r\u00e9cup\u00e9r\u00e9e.");
                }
            } else if (codeReponse == 404) {
                this.message(2, "getPhoto - Le serveur a indiqu\u00e9 que la photo n'existait pas.");
                resultat = null;
            } else {
                this.message(0, "getPhoto - Le serveur de photos n'a pas delivre la photo : " + codeReponse + " - " + conn.getResponseMessage());
                pex = new PhotoClientException("Le serveur de photos n'a pas pu delivrer la photo.");
                resultat = null;
            }
            conn.disconnect();
        }
        catch (IOException exc) {
            this.message(0, "getPhoto - Erreur sur le flux de l'image :" + exc);
            pex = new PhotoClientException("Erreur au lors de la connexion au serveur de photos.");
            conn.disconnect();
        }
        if (pex != null) {
            throw pex;
        }
        return resultat;
    }

    public void putPhoto(String url, Object imageObject) throws PhotoClientException {
        HttpURLConnection conn = this.openConnexion(url, "PUT");
        if (conn == null) {
            throw new PhotoClientException("Impossible d'\u00e9tablir la connexion au serveur de photos.");
        }
        PhotoClientException pex = null;
        OutputStream os = null;
        try {
            boolean ok = false;
            os = conn.getOutputStream();
            if (imageObject instanceof BufferedImage) {
                BufferedImage bim = (BufferedImage)imageObject;
                ok = ImageIO.write((RenderedImage)bim, "JPEG", os);
            } else if (imageObject instanceof byte[]) {
                byte[] data = (byte[])imageObject;
                os.write(data);
                ok = true;
            } else {
                this.message(0, "Classe d'image non geree : " + imageObject.getClass());
                ok = false;
            }
            os.flush();
            if (ok) {
                int codeReponse = conn.getResponseCode();
                if (codeReponse == 201 || codeReponse == 200) {
                    this.message(2, "putPhoto - La photo a ete deposee avec succes");
                } else {
                    this.message(0, "putPhoto - Le serveur de photos a retourne une erreur pour la raison suivante :" + codeReponse + " - " + conn.getResponseMessage());
                    pex = new PhotoClientException("Le serveur de photo a retourn\u00e9 une erreur lors d\u00e9p\u00f4t.");
                }
            } else {
                this.message(0, "Erreur pendant l'ecriture de l'image JPEG dans le flux");
                pex = new PhotoClientException("Erreur pendant de la transmission de l'image.");
            }
            os.close();
            conn.disconnect();
        }
        catch (IOException exc) {
            this.message(0, "putPhoto - Erreur \u00e0 l'ecriture de l'image :" + exc);
            pex = new PhotoClientException("Une erreur s'est produite sur la connexion au serveur de photos.");
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            conn.disconnect();
        }
        if (pex != null) {
            throw pex;
        }
    }

    public void deletePhoto(String url) throws PhotoClientException {
        PhotoClientException pex = null;
        HttpURLConnection conn = this.openConnexion(url, "DELETE");
        if (conn == null) {
            throw new PhotoClientException("Impossible d'\u00e9tablir la connexion au serveur de photos.");
        }
        try {
            int codeReponse = conn.getResponseCode();
            if (codeReponse == 204) {
                this.message(2, "putPhoto - La photo a ete supprimmee avec succes");
            } else {
                this.message(0, "putPhoto - Le serveur de photos a retourn\u00e9 une erreur pour la raison suivante :" + codeReponse + " - " + conn.getResponseMessage());
                pex = new PhotoClientException("Le serveur de photo a retourn\u00e9 une erreur lors de la suppression.");
            }
            conn.disconnect();
        }
        catch (IOException exc) {
            conn.disconnect();
            this.message(0, "Erreur sur la communication HTTP :" + exc);
            pex = new PhotoClientException("Erreur lors de la communication avec le serveur.");
        }
        if (pex != null) {
            throw pex;
        }
    }

    public TicketClient requestTicket(String url) throws PhotoClientException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserEx) {
            this.message(0, "Impossible d'obtenir un parseur XML : " + parserEx);
            throw new PhotoClientException("Une erreur s'est produite \u00e0 la cr\u00e9ation de l'analyseur de r\u00e9ponse.");
        }
        HttpURLConnection conn = this.openConnexion(url, "GET");
        if (conn == null) {
            throw new PhotoClientException("Impossible d'\u00e9tablir une connexion avec le serveur de photos.");
        }
        TicketClient ticket = null;
        PhotoClientException pex = null;
        try {
            int codeReponse = conn.getResponseCode();
            if (codeReponse == 200) {
                InputStream is = conn.getInputStream();
                Document doc = null;
                try {
                    doc = builder.parse(is);
                }
                catch (SAXException saxEx) {
                    this.message(0, "Erreur de syntaxe XML dans la reponse du serveur " + saxEx);
                }
                catch (IOException ioEx) {
                    this.message(0, "Erreur lors de la lecture des informations du ticket " + ioEx);
                }
                is.close();
                if (doc != null) {
                    ticket = new TicketClient();
                    Element infosTicket = (Element)doc.getElementsByTagName("ticket").item(0);
                    ticket.setCode(infosTicket.getAttribute("code"));
                    ticket.setTemoinPriv(infosTicket.getAttribute("priv"));
                    try {
                        ticket.setExpirationDate(infosTicket.getAttribute("expire"));
                    }
                    catch (TicketException e) {
                        this.message(0, e.toString());
                        pex = new PhotoClientException("La date indiqu\u00e9e dans le ticket est incorrecte.");
                        ticket = null;
                    }
                } else {
                    pex = new PhotoClientException("Une erreur s'est produite lors de la r\u00e9cup\u00e9ration des informations du ticket.");
                }
            } else {
                this.message(0, "requestTicket - Le serveur de photos n'a pas delivre le ticket pour la raison suivante :" + codeReponse + " - " + conn.getResponseMessage());
                ticket = null;
                pex = new PhotoClientException("Le serveur de photos n'a pas d\u00e9livr\u00e9 de ticket.");
            }
            conn.disconnect();
        }
        catch (IOException exc) {
            this.message(0, "requestTicket - Erreur E/S pendant la recuperation du ticket:" + exc);
            conn.disconnect();
        }
        if (pex != null) {
            throw pex;
        }
        return ticket;
    }

    private HttpURLConnection openConnexion(String url, String method) {
        this.message(2, "Requ\u00eate HTTP de type " + method + " sur l'URL '" + url + "'");
        try {
            URL adresse = new URL(url);
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)adresse.openConnection();
                conn.setRequestMethod(method);
                conn.setDoOutput(method.equals("PUT") || method.equals("POST"));
                conn.connect();
                return conn;
            }
            catch (IOException e) {
                this.message(0, "Erreur E/S lors de l'etablissement de la connexion HTTP avec le serveur de photos" + e);
                if (conn != null) {
                    conn.disconnect();
                    conn = null;
                }
                return conn;
            }
        }
        catch (MalformedURLException e) {
            this.message(0, "L'url d'appel du serveur de photos (" + url + ") est invalide  : " + e);
            return null;
        }
    }
}

