/*
 * Decompiled with CFR 0.152.
 */
package fr.univnancy2.PhotoClient.beans;

import fr.univnancy2.PhotoClient.exception.TicketException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class TicketClient {
    public static final DateFormat EXPIRATION_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private String code;
    private Date dateExpiration;
    private boolean temoinPriv;
    private String logName = "NONE";

    public final void setCode(String codeValue) {
        this.code = codeValue;
    }

    public final String getCode() {
        return this.code;
    }

    public void setExpirationDate(String chaineDate) throws TicketException {
        try {
            this.dateExpiration = EXPIRATION_DATE_FORMAT.parse(chaineDate);
        }
        catch (ParseException e) {
            throw new TicketException("La date d'expiration du ticket est invalide " + chaineDate);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Ticket (Code = ");
        sb.append(this.code);
        sb.append(", expire = ");
        sb.append(EXPIRATION_DATE_FORMAT.format(this.dateExpiration));
        sb.append(", mode_priv = ");
        sb.append(this.getTemoinPriv());
        sb.append(")");
        return sb.toString();
    }

    public boolean isValid(int delaySec) {
        if (this.code == null || this.dateExpiration == null) {
            return false;
        }
        GregorianCalendar currentCal = new GregorianCalendar();
        currentCal.add(13, delaySec);
        Date dateCourante = currentCal.getTime();
        return !dateCourante.after(this.dateExpiration);
    }

    public void setTemoinPriv(String valeur) {
        this.temoinPriv = valeur == null ? false : valeur.equals("O");
    }

    public String getTemoinPriv() {
        return this.temoinPriv ? "O" : "N";
    }

    public boolean hasTemoinPriv() {
        return this.temoinPriv;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public String getLogName() {
        return this.logName;
    }
}

