/*
 * Decompiled with CFR 0.152.
 */
package fr.univnancy2.PhotoClient.beans;

import fr.univnancy2.PhotoClient.beans.Category;
import fr.univnancy2.PhotoClient.beans.ISimpleLogger;
import fr.univnancy2.PhotoClient.beans.TicketClient;
import fr.univnancy2.PhotoClient.dao.WebServiceClient;
import fr.univnancy2.PhotoClient.exception.PhotoClientException;
import fr.univnancy2.PhotoClient.tools.HexTools;
import java.awt.image.BufferedImage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PhotoClient
implements ISimpleLogger {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_PRIVILEGIE = 1;
    private static final String[] MODE_PARAMETER_VALUE = new String[]{"normal", "priv"};
    private ISimpleLogger traceur = null;
    private WebServiceClient webService = null;
    private String ticketURLPattern = null;
    private String ressourceURLPattern = null;
    private String ressourceByLoginURLPattern = null;
    private String appCode;

    public PhotoClient() {
        this(null);
    }

    public PhotoClient(ISimpleLogger logger) {
        this.traceur = logger;
        this.webService = new WebServiceClient(this);
        this.appCode = "NONE";
    }

    public final void notify(int niveau, String message) {
        if (this.traceur != null) {
            this.traceur.notify(niveau, message);
        }
    }

    public final String getTicketURLPattern() {
        return this.ticketURLPattern;
    }

    public final void setTicketURLPattern(String ticketPattern) {
        this.ticketURLPattern = ticketPattern;
    }

    public final String getRessourceURLPattern() {
        return this.ressourceURLPattern;
    }

    public final void setRessourceURLPattern(String ressourcePattern) {
        this.ressourceURLPattern = ressourcePattern;
    }

    public final String getRessourceByLoginURLPattern() {
        return this.ressourceByLoginURLPattern;
    }

    public final void setRessourceByLoginURLPattern(String ressourcePattern) {
        this.ressourceByLoginURLPattern = ressourcePattern;
    }

    public String computeURLforCode(Category category, String code, TicketClient ticket) throws PhotoClientException {
        if (this.ressourceURLPattern == null) {
            this.notify(0, "Motif d'URL des ressources non specifie (null).");
            throw new PhotoClientException("Le motif des URL de ressource n'a pas \u00e9t\u00e9 sp\u00e9cifi\u00e9.");
        }
        String signature = this.computeSignature(String.valueOf(this.appCode) + ticket.getLogName() + category.getName() + code);
        String url = this.ressourceURLPattern.replaceAll("%category%", category.getName()).replaceAll("%code%", code).replaceAll("%ticket%", ticket.getCode()).replaceAll("%chksum%", signature);
        return url;
    }

    public String computeURLforLogin(Category category, String login, TicketClient ticket) throws PhotoClientException {
        if (this.ressourceByLoginURLPattern == null) {
            this.notify(0, "Motif d'URL des ressources par login non specifie (null).");
            throw new PhotoClientException("Le motif des URL de ressource par login n'a pas \u00e9t\u00e9 sp\u00e9cifi\u00e9.");
        }
        String signature = this.computeSignature(String.valueOf(this.appCode) + ticket.getLogName() + category.getName() + login);
        String url = this.ressourceByLoginURLPattern.replaceAll("%category%", category.getName()).replaceAll("%login%", login).replaceAll("%ticket%", ticket.getCode()).replaceAll("%chksum%", signature);
        return url;
    }

    public final byte[] getPhotoBytes(Category category, String code, TicketClient ticket) throws PhotoClientException {
        return (byte[])this.webService.getPhoto(this.computeURLforCode(category, code, ticket), "byte[]");
    }

    public final byte[] getPhotoBytesByLogin(Category category, String login, TicketClient ticket) throws PhotoClientException {
        return (byte[])this.webService.getPhoto(this.computeURLforLogin(category, login, ticket), "byte[]");
    }

    public final BufferedImage getPhotoImage(Category category, String code, TicketClient ticket) throws PhotoClientException {
        return (BufferedImage)this.webService.getPhoto(this.computeURLforCode(category, code, ticket), "BufferedImage");
    }

    public final BufferedImage getPhotoImageByLogin(Category category, String login, TicketClient ticket) throws PhotoClientException {
        return (BufferedImage)this.webService.getPhoto(this.computeURLforLogin(category, login, ticket), "BufferedImage");
    }

    public final void putPhoto(Category category, String code, BufferedImage newPhoto, TicketClient ticket) throws PhotoClientException {
        this.webService.putPhoto(this.computeURLforCode(category, code, ticket), newPhoto);
    }

    public final void putPhotoByLogin(Category category, String login, BufferedImage newPhoto, TicketClient ticket) throws PhotoClientException {
        this.webService.putPhoto(this.computeURLforLogin(category, login, ticket), newPhoto);
    }

    public final void putPhoto(Category category, String code, byte[] newPhoto, TicketClient ticket) throws PhotoClientException {
        this.webService.putPhoto(this.computeURLforCode(category, code, ticket), newPhoto);
    }

    public final void putPhotoByLogin(Category category, String login, byte[] newPhoto, TicketClient ticket) throws PhotoClientException {
        this.webService.putPhoto(this.computeURLforLogin(category, login, ticket), newPhoto);
    }

    public final void deletePhoto(Category category, String code, TicketClient ticket) throws PhotoClientException {
        this.webService.deletePhoto(this.computeURLforCode(category, code, ticket));
    }

    public final void deletePhotoByLogin(Category category, String login, TicketClient ticket) throws PhotoClientException {
        this.webService.deletePhoto(this.computeURLforLogin(category, login, ticket));
    }

    public final TicketClient getTicket(int mode, String typLim, String valLim, String logName) throws PhotoClientException {
        String ip = "";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e1) {
            this.notify(0, "UnknownHostException : " + e1.toString());
            throw new PhotoClientException("Impossible de d\u00e9terminer l'adresse IP locale.");
        }
        return this.getTicket(mode, ip, typLim, valLim, logName);
    }

    public final TicketClient getTicket(int mode, String ipAdress, String typLim, String valLim, String logName) throws PhotoClientException {
        if (this.ticketURLPattern == null) {
            this.notify(0, "Motif d'URL des demandes de tickets non specifie (null).");
            throw new PhotoClientException("Le motif des URL des demandes de tickets n'a pas \u00e9t\u00e9 sp\u00e9cifi\u00e9.");
        }
        String url = this.ticketURLPattern.replaceAll("%ip%", ipAdress).replaceAll("%mode%", MODE_PARAMETER_VALUE[mode]).replaceAll("%typLim%", typLim).replaceAll("%valLim%", valLim).replaceAll("%client%", String.valueOf(this.appCode) + "!" + logName);
        TicketClient tik = this.webService.requestTicket(url);
        if (tik == null) {
            throw new PhotoClientException("Impossible d'obtenir un ticket. Consultez les logs pour plus d'informations.");
        }
        tik.setLogName(logName);
        return tik;
    }

    private String computeSignature(String data) throws PhotoClientException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            this.notify(2, "computeCheckSum - data : " + data);
            return HexTools.bufferToHexString(md.digest(data.getBytes()), null);
        }
        catch (NoSuchAlgorithmException e) {
            this.notify(0, "computeCheckSum - Erreur a la creation du Message Digest : Algorithme SHA-1 Indisponible");
            throw new PhotoClientException("Impossible de calculer le checksum de la requete - Algorithme SHA-1 indisponible");
        }
    }

    public void setApplicationCode(String appCode) {
        this.appCode = appCode;
    }
}

