/*
 * Decompiled with CFR 0.152.
 */
package fr.univnancy2.PhotoClient.beans;

import fr.univnancy2.PhotoClient.beans.Category;
import fr.univnancy2.PhotoClient.beans.ISimpleLogger;
import fr.univnancy2.PhotoClient.beans.PhotoClient;
import fr.univnancy2.PhotoClient.beans.TicketClient;
import fr.univnancy2.PhotoClient.exception.PhotoClientException;
import java.awt.image.BufferedImage;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class LocalPhotoClient
extends PhotoClient {
    private TicketClient currentTicket = null;
    private String localHost = null;
    private int securityDelayTicket;
    private int modeClient;
    private String typeLimite;
    private String valeurLimite;

    public LocalPhotoClient(int modeDemande, ISimpleLogger logger) throws PhotoClientException {
        this(modeDemande, "NO_LIMIT", "NONE", 60, logger);
    }

    public LocalPhotoClient(int modeDemande, String typLim, String valLim, int secDelay) throws PhotoClientException {
        this(modeDemande, typLim, valLim, secDelay, null);
    }

    public LocalPhotoClient(int modeDemande, String typLim, String valLim, int secDelay, ISimpleLogger logger) throws PhotoClientException {
        super(logger);
        this.modeClient = modeDemande;
        this.typeLimite = typLim;
        this.valeurLimite = valLim;
        this.securityDelayTicket = secDelay;
        try {
            this.localHost = Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this.notify(0, "UnknownHostException : " + e);
            throw new PhotoClientException("Impossible de d\u00e9terminer l'adresse IP locale. " + e.getMessage());
        }
    }

    public final byte[] getPhotoBytes(Category category, String code) throws PhotoClientException {
        this.refreshLocalTicket();
        return this.getPhotoBytes(category, code, this.currentTicket);
    }

    public final byte[] getPhotoBytesByLogin(Category category, String login) throws PhotoClientException {
        this.refreshLocalTicket();
        return this.getPhotoBytesByLogin(category, login, this.currentTicket);
    }

    public final BufferedImage getPhotoImage(Category category, String code) throws PhotoClientException {
        this.refreshLocalTicket();
        return this.getPhotoImage(category, code, this.currentTicket);
    }

    public final BufferedImage getPhotoImageByLogin(Category category, String login) throws PhotoClientException {
        this.refreshLocalTicket();
        return this.getPhotoImageByLogin(category, login, this.currentTicket);
    }

    public final void putPhoto(Category category, String code, BufferedImage newPhoto) throws PhotoClientException {
        if (this.modeClient != 1) {
            this.notify(0, "Le client photo n'est pas autorise a d\u00e9poser une photo");
            throw new PhotoClientException("Le client photo n'est pas autoris\u00e9 a d\u00e9poser une photo");
        }
        this.refreshLocalTicket();
        this.putPhoto(category, code, newPhoto, this.currentTicket);
    }

    public final void putPhotoByLogin(Category category, String login, BufferedImage newPhoto) throws PhotoClientException {
        if (this.modeClient != 1) {
            this.notify(0, "Le client photo n'est pas autorise a d\u00e9poser une photo");
            throw new PhotoClientException("Le client photo n'est pas autoris\u00e9 a d\u00e9poser une photo");
        }
        this.refreshLocalTicket();
        this.putPhotoByLogin(category, login, newPhoto, this.currentTicket);
    }

    public final void putPhoto(Category category, String code, byte[] newPhoto) throws PhotoClientException {
        if (this.modeClient != 1) {
            this.notify(0, "Le client photo n'est pas autorise a d\u00e9poser une photo");
            throw new PhotoClientException("Le client photo n'est pas autoris\u00e9 a d\u00e9poser une photo");
        }
        this.refreshLocalTicket();
        this.putPhoto(category, code, newPhoto, this.currentTicket);
    }

    public final void putPhotoByLogin(Category category, String login, byte[] newPhoto) throws PhotoClientException {
        if (this.modeClient != 1) {
            this.notify(0, "Le client photo n'est pas autorise a d\u00e9poser une photo");
            throw new PhotoClientException("Le client photo n'est pas autoris\u00e9 a d\u00e9poser une photo");
        }
        this.refreshLocalTicket();
        this.putPhotoByLogin(category, login, newPhoto, this.currentTicket);
    }

    public final void deletePhoto(Category category, String code) throws PhotoClientException {
        if (this.modeClient != 1) {
            this.notify(0, "Le client photo n'est pas autorise a supprimmer une photo");
            throw new PhotoClientException("Le client photo n'est pas autoris\u00e9 a supprimmer une photo");
        }
        this.refreshLocalTicket();
        this.deletePhoto(category, code, this.currentTicket);
    }

    public final void deletePhotoByLogin(Category category, String login) throws PhotoClientException {
        if (this.modeClient != 1) {
            this.notify(0, "Le client photo n'est pas autorise a supprimmer une photo");
            throw new PhotoClientException("Le client photo n'est pas autoris\u00e9 a supprimmer une photo");
        }
        this.refreshLocalTicket();
        this.deletePhotoByLogin(category, login, this.currentTicket);
    }

    private final void refreshLocalTicket() throws PhotoClientException {
        try {
            if (this.currentTicket == null) {
                this.currentTicket = this.getTicket(this.modeClient, this.localHost, this.typeLimite, this.valeurLimite, "NONE");
                return;
            }
            if (!this.currentTicket.isValid(this.securityDelayTicket)) {
                this.currentTicket = this.getTicket(this.modeClient, this.localHost, this.typeLimite, this.valeurLimite, "NONE");
                return;
            }
        }
        catch (PhotoClientException e) {
            this.currentTicket = null;
            throw e;
        }
    }

    public int getSecurityDelayTicket() {
        return this.securityDelayTicket;
    }

    public void setSecurityDelayTicket(int securityDelayTicket) {
        this.securityDelayTicket = securityDelayTicket;
    }
}

