/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.mondossierweb.tools.elasticsearch;

import fr.univlorraine.mondossierweb.tools.elasticsearch.ElasticSearchApogeeService;
import fr.univlorraine.mondossierweb.tools.elasticsearch.ElasticSearchClientInitializer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ElasticSearchApogeeServiceImpl
implements ElasticSearchApogeeService {
    private Logger logger = LoggerFactory.getLogger(ElasticSearchApogeeServiceImpl.class);
    private String typCmp = "";
    private String typVet = "";
    private String typElp = "";
    private String typEtu = "";
    private String esTyp = "";
    private Client client;
    private String elasticSearchCluster;
    private String elasticSearchUrl;
    private int elasticSearchPort;
    private String elasticSearchIndex;
    private String elasticSearchChampRecherche;
    private String elasticSearchChampCodeObjet;
    private String elasticSearchChampVersionObjet;

    public ElasticSearchApogeeServiceImpl() {
    }

    public ElasticSearchApogeeServiceImpl(String elasticSearchUrl, int elasticSearchPort, String elasticSearchCluster, String typCmp, String typVet, String typElp, String typEtu, String esTyp) {
        this.typCmp = typCmp;
        this.typVet = typVet;
        this.typElp = typElp;
        this.typEtu = typEtu;
        this.esTyp = esTyp;
        this.elasticSearchCluster = elasticSearchCluster;
        this.elasticSearchUrl = elasticSearchUrl;
        this.elasticSearchPort = elasticSearchPort;
    }

    @Override
    public boolean initConnexion() {
        return this.initConnexion(this.elasticSearchUrl, this.elasticSearchPort, this.elasticSearchCluster);
    }

    @Override
    public boolean initConnexion(String url, int port, String cluster) {
        if (this.client == null) {
            try {
                this.client = ElasticSearchClientInitializer.initClient(url, port, cluster);
            }
            catch (Exception ex) {
                this.logger.error("probl\u00e8me lors de l'initialisation de la connexion \u00e0 ElasticSerch", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<Map<String, Object>> findObj(String value, int maxResult, boolean quickSearck) {
        return this.findObj(value, maxResult, quickSearck, this.elasticSearchIndex, this.elasticSearchChampRecherche, this.elasticSearchChampCodeObjet, this.elasticSearchChampVersionObjet);
    }

    @Override
    public List<Map<String, Object>> findObj(String value, int maxResult, boolean quickSearck, String elasticSearchIndex, String elasticSearchChampRecherche, String elasticSearchChampCodeObjet, String elasticSearchChampVersionObjet) {
        this.initConnexion();
        LinkedList<Map<String, Object>> listeResultats = new LinkedList<Map<String, Object>>();
        if (StringUtils.hasText((String)value)) {
            MatchQueryBuilder qb;
            boolean rechercherParCode = false;
            String lastWordCompletion = "*";
            value = value.replaceAll("-", " ");
            value = value.replaceAll("\\(", " ");
            value = value.replaceAll("\\)", " ");
            while (value.contains("  ")) {
                value = value.replaceAll("  ", " ");
            }
            if (value.contains("[") && value.contains("]")) {
                value = value.replaceAll("\\[", "");
                value = value.split("\\]")[0];
                rechercherParCode = true;
            } else {
                value = value.replaceAll("\\[", "");
                if ((value = value.replaceAll("\\]", "")).substring(value.length() - 1).equals(" ")) {
                    lastWordCompletion = "";
                }
                value = value.trim();
                value = value.replaceAll("-", "\\-");
            }
            value = value.toLowerCase();
            SearchHit[] results = null;
            SearchResponse response = null;
            if (!rechercherParCode) {
                qb = QueryBuilders.matchQuery((String)elasticSearchChampRecherche, (Object)value);
                if (quickSearck) {
                    String[] mots = value.split(" ");
                    if (mots.length == 1) {
                        qb = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.wildcardQuery((String)elasticSearchChampRecherche, (String)(mots[0] + lastWordCompletion)));
                    } else {
                        BoolQueryBuilder bqb = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)elasticSearchChampRecherche, (Object)mots[0]));
                        for (int i = 1; i < mots.length; ++i) {
                            if (i < mots.length - 1) {
                                bqb.must((QueryBuilder)QueryBuilders.matchQuery((String)elasticSearchChampRecherche, (Object)mots[i]));
                                continue;
                            }
                            bqb.must((QueryBuilder)QueryBuilders.wildcardQuery((String)elasticSearchChampRecherche, (String)(mots[i] + lastWordCompletion)));
                        }
                        qb = bqb;
                    }
                }
                response = (SearchResponse)this.client.prepareSearch(new String[]{elasticSearchIndex}).setSearchType(SearchType.QUERY_AND_FETCH).setTypes(new String[]{this.typCmp, this.typVet, this.typEtu}).setQuery((QueryBuilder)qb).setFrom(0).setSize(60).setExplain(true).execute().actionGet();
                results = response.getHits().getHits();
            }
            if (rechercherParCode || (results == null || results.length == 0) && !quickSearck) {
                qb = QueryBuilders.matchQuery((String)elasticSearchChampCodeObjet, (Object)value);
                response = (SearchResponse)this.client.prepareSearch(new String[]{elasticSearchIndex}).setSearchType(SearchType.QUERY_AND_FETCH).setTypes(new String[]{this.typCmp, this.typVet, this.typElp, this.typEtu}).setQuery((QueryBuilder)qb).setFrom(0).setSize(60).setExplain(true).execute().actionGet();
                results = response.getHits().getHits();
            }
            for (void var17_18 : results) {
                if (listeResultats.size() >= maxResult + 1) continue;
                Map result = var17_18.getSource();
                result.put(this.esTyp, var17_18.getType());
                if (!rechercherParCode) {
                    listeResultats.add(result);
                    continue;
                }
                String codres = (String)result.get(elasticSearchChampCodeObjet);
                codres = codres.toLowerCase();
                int vrsres = (Integer)result.get(elasticSearchChampVersionObjet);
                if (!value.contains("/") && codres.equals(value)) {
                    listeResultats.add(result);
                }
                if (!value.contains("/") || !(codres + "/" + vrsres).equals(value)) continue;
                listeResultats.add(result);
            }
        }
        return listeResultats;
    }

    public String getTypCmp() {
        return this.typCmp;
    }

    public void setTypCmp(String typCmp) {
        this.typCmp = typCmp;
    }

    public String getTypVet() {
        return this.typVet;
    }

    public void setTypVet(String typVet) {
        this.typVet = typVet;
    }

    public String getTypElp() {
        return this.typElp;
    }

    public void setTypElp(String typElp) {
        this.typElp = typElp;
    }

    public String getTypEtu() {
        return this.typEtu;
    }

    public void setTypEtu(String typEtu) {
        this.typEtu = typEtu;
    }

    public String getEsTyp() {
        return this.esTyp;
    }

    public void setEsTyp(String esTyp) {
        this.esTyp = esTyp;
    }

    public String getElasticSearchCluster() {
        return this.elasticSearchCluster;
    }

    public void setElasticSearchCluster(String elasticSearchCluster) {
        this.elasticSearchCluster = elasticSearchCluster;
    }

    public String getElasticSearchUrl() {
        return this.elasticSearchUrl;
    }

    public void setElasticSearchUrl(String elasticSearchUrl) {
        this.elasticSearchUrl = elasticSearchUrl;
    }

    public int getElasticSearchPort() {
        return this.elasticSearchPort;
    }

    public void setElasticSearchPort(int elasticSearchPort) {
        this.elasticSearchPort = elasticSearchPort;
    }

    public String getElasticSearchIndex() {
        return this.elasticSearchIndex;
    }

    public void setElasticSearchIndex(String elasticSearchIndex) {
        this.elasticSearchIndex = elasticSearchIndex;
    }

    public String getElasticSearchChampRecherche() {
        return this.elasticSearchChampRecherche;
    }

    public void setElasticSearchChampRecherche(String elasticSearchChampRecherche) {
        this.elasticSearchChampRecherche = elasticSearchChampRecherche;
    }

    public String getElasticSearchChampCodeObjet() {
        return this.elasticSearchChampCodeObjet;
    }

    public void setElasticSearchChampCodeObjet(String elasticSearchChampCodeObjet) {
        this.elasticSearchChampCodeObjet = elasticSearchChampCodeObjet;
    }

    public String getElasticSearchChampVersionObjet() {
        return this.elasticSearchChampVersionObjet;
    }

    public void setElasticSearchChampVersionObjet(String elasticSearchChampVersionObjet) {
        this.elasticSearchChampVersionObjet = elasticSearchChampVersionObjet;
    }
}

