package fr.univlorraine.mondossierweb.tools.elasticsearch;

import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;

public class ElasticSearchClientInitializer {
	
	

	public static Client initClient(String elasticSearchUrl, int elasticSearchPort, String elasticSearchCluster){
		/* ES V1 */
		/*Settings settings1 = org.elasticsearch.common.settings.ImmutableSettings.settingsBuilder().put("cluster.name", elasticSearchCluster).build();
		Client client = new org.elasticsearch.client.transport.TransportClient(settings1).addTransportAddress(new InetSocketTransportAddress(elasticSearchUrl, elasticSearchPort));
		 */
		
		/* ES V2  */
		Settings settings2 = Settings.settingsBuilder().put("cluster.name", elasticSearchCluster).build();
		Client client = org.elasticsearch.client.transport.TransportClient.builder().settings(settings2).build().addTransportAddress(new InetSocketTransportAddress(new java.net.InetSocketAddress(elasticSearchUrl, elasticSearchPort)));
		
		return client;
	}
}
