/**
 *
 *  ESUP-Portail MONDOSSIERWEB - Copyright (c) 2016 ESUP-Portail consortium
 *
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package fr.univlorraine.mondossierweb.tools.elasticsearch;

import java.util.List;
import java.util.Map;

/**
 * @author dubois36
 *
 */
public interface ElasticSearchApogeeService {

	/**
	 * Recherche une valeur dans ElasticSearch.
	 * @param value valeur a recherchée
	 * @param maxResult nombre de résultats maximum à retourner
	 * @param quickSearck vrai si on est en quickSearch (autocompletion)
	 * @return retourne une liste de résultats.
	 */
	List<Map<String, Object>> findObj(String value, int maxResult, boolean quickSearck);

	/**
	 * Recherche une valeur dans ElasticSearch.
	 * @param value valeur a recherchée
	 * @param maxResult nombre de résultats maximum à retourner
	 * @param quickSearck vrai si on est en quickSearch (autocompletion)
	 * @param elasticSearchIndex nom de l'index
	 * @param elasticSearchChampRecherche nom du champ dans lequel rechercher la valeur
	 * @param elasticSearchChampCodeObjet nom du champ contenant le code d'un document ES
	 * @param elasticSearchChampVersionObjet nom du champ contenant la version d'un document ES
	 * @return retourne une liste de résultats.
	 */
	List<Map<String, Object>> findObj(String value, int maxResult, boolean quickSearck, String elasticSearchIndex, String elasticSearchChampRecherche, String elasticSearchChampCodeObjet, String elasticSearchChampVersionObjet);

	/**
	 * Initialise la connexion vers ElasticSearch.
	 * @return true si la connexion a été correctement effectuée
	 */
	boolean initConnexion();

	/**
	 * Initialise la connexion vers ElasticSearch.
	 * @param url url du serveur ES
	 * @param port port de connexion au serveur ES
	 * @param cluster cluster ES
	 * @return true si la connexion a été correctement effectuée
	 */
	boolean initConnexion(String url,  int port, String cluster);
}
