/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.views;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.fieldgroup.BeanFieldGroup;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.data.fieldgroup.PropertyId;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.shared.ui.datefield.Resolution;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.DateField;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.VerticalLayout;
import fr.univlorraine.fwa.controllers.FwaAppController;
import fr.univlorraine.fwa.controllers.FwaMsgController;
import fr.univlorraine.fwa.controllers.FwaNotMsgController;
import fr.univlorraine.fwa.controllers.LockController;
import fr.univlorraine.fwa.entities.FwaApp_;
import fr.univlorraine.fwa.entities.FwaMsg;
import fr.univlorraine.fwa.entities.FwaMsg_;
import fr.univlorraine.fwa.utils.Utils;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import ru.xpoft.vaadin.VaadinView;

@Component
@Scope(value="prototype")
@VaadinView(value="messageView")
public class MessageView
extends HorizontalSplitPanel
implements View {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "messageView";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final float DEFINEDWIDTH = 210.0f;
    private static final String DOT = ".";
    @Resource
    private transient ApplicationContext applicationContext;
    @Resource
    private transient LockController lockController;
    @Resource
    private transient FwaAppController appController;
    @Resource
    private transient FwaMsgController msgController;
    @Resource
    private transient FwaNotMsgController notMsgController;
    private BeanItemContainer<FwaMsg> msgContainer;
    private FwaMsg newFwaMsg;
    private BeanItem<FwaMsg> selectedMsgItem;
    private FieldGroup fieldGroup;
    private static final String LIB_APP = FwaMsg_.fwaApp.getName() + "." + FwaApp_.libApp.getName();
    private static final String LIB_MSG = FwaMsg_.libMsg.getName();
    private static final Object[] MSG_VISIBLE_COLUMNS = new Object[]{LIB_APP, LIB_MSG};
    private static String SIMPLEDATF = "dd/MM/yyyy HH:mm";
    private VerticalLayout msgTableLayout = new VerticalLayout();
    private Label titre = new Label();
    private Label selectMsg = new Label();
    private Table msgTable = new Table();
    private HorizontalLayout buttonsTableLayout = new HorizontalLayout();
    private Button newBtn = new Button();
    private Button deleteBtn = new Button();
    private VerticalLayout msgDetailLayout = new VerticalLayout();
    private Label msgTitre = new Label();
    private FormLayout msgFormLayout = new FormLayout();
    @PropertyId(value="fwaApp")
    private NativeSelect applicationSelect = new NativeSelect();
    @PropertyId(value="libMsg")
    private TextArea msgText = new TextArea();
    @PropertyId(value="datDebMsg")
    private DateField dateDebutField = new DateField();
    @PropertyId(value="datFinMsg")
    private DateField dateFinField = new DateField();
    private HorizontalLayout buttonsLayout = new HorizontalLayout();
    private Button saveBtn = new Button();
    private Button cancelBtn = new Button();
    private ThemeResource addIcon = new ThemeResource("icons/add.png");
    private ThemeResource saveIcon = new ThemeResource("icons/disk.png");
    private ThemeResource deleteIcon = new ThemeResource("icons/delete.png");
    private ThemeResource crossIcon = new ThemeResource("icons/cross.png");

    @PostConstruct
    public void init() {
        this.setSplitPosition(550.0f, Sizeable.Unit.PIXELS);
        this.setLocked(true);
        this.setWidth(1000.0f, Sizeable.Unit.PIXELS);
        this.setHeight(410.0f, Sizeable.Unit.PIXELS);
        this.msgTableLayout.setMargin(new MarginInfo(true, false, true, true));
        this.msgTableLayout.setSpacing(true);
        this.msgTableLayout.setWidth(510.0f, Sizeable.Unit.PIXELS);
        this.titre.setCaption(this.applicationContext.getMessage("messageView.titre", null, Locale.getDefault()));
        this.titre.addStyleName("h2");
        this.msgTable.setImmediate(true);
        this.msgTable.setSelectable(true);
        this.msgTable.setWidth(460.0f, Sizeable.Unit.PIXELS);
        this.msgTable.setHeight(240.0f, Sizeable.Unit.PIXELS);
        this.msgTable.setStyleName("wordwrap-table");
        this.msgContainer = this.msgController.getMsgs();
        this.customTable();
        this.msgTable.addValueChangeListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonsTableLayout.setMargin(true);
        this.buttonsTableLayout.setSpacing(true);
        this.buttonsTableLayout.setSizeFull();
        this.newBtn.setIcon((com.vaadin.server.Resource)this.addIcon);
        this.newBtn.setCaption(this.applicationContext.getMessage("messageView.new", null, Locale.getDefault()));
        this.newBtn.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteBtn.setIcon((com.vaadin.server.Resource)this.deleteIcon);
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.setCaption(this.applicationContext.getMessage("messageView.delete", null, Locale.getDefault()));
        this.deleteBtn.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.msgTableLayout.addComponent((com.vaadin.ui.Component)this.titre);
        this.msgTableLayout.addComponent((com.vaadin.ui.Component)this.msgTable);
        this.buttonsTableLayout.addComponent((com.vaadin.ui.Component)this.newBtn);
        this.buttonsTableLayout.setComponentAlignment((com.vaadin.ui.Component)this.newBtn, Alignment.MIDDLE_CENTER);
        this.buttonsTableLayout.addComponent((com.vaadin.ui.Component)this.deleteBtn);
        this.msgTableLayout.addComponent((com.vaadin.ui.Component)this.buttonsTableLayout);
        this.msgDetailLayout.setMargin(true);
        this.msgDetailLayout.setSpacing(true);
        this.selectMsg = new Label(this.applicationContext.getMessage("messageView.select.msg", null, Locale.getDefault()));
        this.selectMsg.setStyleName("middlePage");
        this.msgDetailLayout.addComponent((com.vaadin.ui.Component)this.selectMsg);
        this.msgTitre.addStyleName("h2");
        this.applicationSelect.setImmediate(true);
        this.applicationSelect.setWidth(210.0f, Sizeable.Unit.PIXELS);
        this.applicationSelect.setCaption(this.applicationContext.getMessage("messageView.msg.application", null, Locale.getDefault()));
        this.applicationSelect.setContainerDataSource((Container)this.appController.getApps());
        this.applicationSelect.setItemCaptionPropertyId((Object)FwaApp_.libApp.getName());
        this.applicationSelect.setNullSelectionAllowed(false);
        Utils.selectDefaultOnNativeSelect((NativeSelect)this.applicationSelect);
        this.msgText.setCaption(this.applicationContext.getMessage("messageView.msg.message", null, Locale.getDefault()));
        this.msgText.setRequired(true);
        this.msgText.setRows(4);
        this.msgText.setMaxLength(255);
        this.msgText.setNullRepresentation("");
        this.msgText.setWidth(210.0f, Sizeable.Unit.PIXELS);
        this.dateDebutField.setImmediate(true);
        this.dateDebutField.setRequired(true);
        this.dateDebutField.setWidth(210.0f, Sizeable.Unit.PIXELS);
        this.dateDebutField.setResolution(Resolution.MINUTE);
        this.dateDebutField.setDateFormat(SIMPLEDATF);
        this.dateDebutField.setCaption(this.applicationContext.getMessage("messageView.date.debut", null, Locale.getDefault()));
        this.dateDebutField.setParseErrorMessage(this.applicationContext.getMessage("messageView.date.error.format", null, Locale.getDefault()));
        this.dateFinField.setImmediate(true);
        this.dateFinField.setRequired(true);
        this.dateFinField.setWidth(210.0f, Sizeable.Unit.PIXELS);
        this.dateFinField.setResolution(Resolution.MINUTE);
        this.dateFinField.setDateFormat(SIMPLEDATF);
        this.dateFinField.setCaption(this.applicationContext.getMessage("messageView.date.fin", null, Locale.getDefault()));
        this.dateFinField.setParseErrorMessage(this.applicationContext.getMessage("messageView.date.error.format", null, Locale.getDefault()));
        this.fieldGroup = new BeanFieldGroup(FwaMsg.class);
        this.fieldGroup.bindMemberFields((Object)this);
        this.saveBtn.setIcon((com.vaadin.server.Resource)this.saveIcon);
        this.saveBtn.setCaption(this.applicationContext.getMessage("messageView.save", null, Locale.getDefault()));
        this.saveBtn.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelBtn.setIcon((com.vaadin.server.Resource)this.crossIcon);
        this.cancelBtn.setCaption(this.applicationContext.getMessage("messageView.cancel", null, Locale.getDefault()));
        this.cancelBtn.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonsLayout.setMargin(true);
        this.buttonsLayout.setSpacing(true);
        this.buttonsLayout.setWidth(300.0f, Sizeable.Unit.PIXELS);
        this.buttonsLayout.addComponent((com.vaadin.ui.Component)this.saveBtn);
        this.buttonsLayout.addComponent((com.vaadin.ui.Component)this.cancelBtn);
        this.msgFormLayout.setMargin(new MarginInfo(false, true, true, false));
        this.msgFormLayout.addComponent((com.vaadin.ui.Component)this.applicationSelect);
        this.msgFormLayout.addComponent((com.vaadin.ui.Component)this.msgText);
        this.msgFormLayout.addComponent((com.vaadin.ui.Component)this.dateDebutField);
        this.msgFormLayout.addComponent((com.vaadin.ui.Component)this.dateFinField);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.setFirstComponent((com.vaadin.ui.Component)this.msgTableLayout);
        this.setSecondComponent((com.vaadin.ui.Component)this.msgDetailLayout);
    }

    private void customTable() {
        this.msgTable.setContainerDataSource((Container)this.msgContainer);
        this.msgTable.setVisibleColumns(MSG_VISIBLE_COLUMNS);
        this.msgTable.setColumnWidth(MSG_VISIBLE_COLUMNS[1], 300);
        String[] columnHeaders = new String[MSG_VISIBLE_COLUMNS.length];
        for (int columnIndex = 0; columnIndex < MSG_VISIBLE_COLUMNS.length; ++columnIndex) {
            columnHeaders[columnIndex] = this.applicationContext.getMessage("messageView.table." + MSG_VISIBLE_COLUMNS[columnIndex], null, Locale.getDefault());
        }
        this.msgTable.setColumnHeaders(columnHeaders);
    }

    private void createMsgDetailLayout(BeanItem<FwaMsg> selectedMsg) {
        this.msgDetailLayout.removeAllComponents();
        if (selectedMsg == null) {
            this.newFwaMsg = new FwaMsg();
            this.fieldGroup.setItemDataSource((Item)new BeanItem((Object)this.newFwaMsg));
            Utils.selectDefaultOnNativeSelect((NativeSelect)this.applicationSelect);
            this.msgTitre.setCaption(this.applicationContext.getMessage("messageView.msg.title.new", null, Locale.getDefault()));
        } else {
            this.fieldGroup.setItemDataSource(selectedMsg);
            this.msgTitre.setCaption(this.applicationContext.getMessage("messageView.msg.title", null, Locale.getDefault()));
        }
        this.msgDetailLayout.addComponent((com.vaadin.ui.Component)this.msgTitre);
        this.msgDetailLayout.addComponent((com.vaadin.ui.Component)this.msgFormLayout);
        this.msgDetailLayout.addComponent((com.vaadin.ui.Component)this.buttonsLayout);
    }

    private void saveAndNotify(FwaMsg msgtoSave) {
        if (this.msgController.save(msgtoSave)) {
            Notification.show((String)this.applicationContext.getMessage("messageView.saved", null, Locale.getDefault()));
            this.msgDetailLayout.removeAllComponents();
            this.msgDetailLayout.addComponent((com.vaadin.ui.Component)this.selectMsg);
            this.msgContainer = this.msgController.getMsgs();
            this.customTable();
        } else {
            this.logger.error((Object)this.applicationContext.getMessage("messageView.saved.error", null, Locale.getDefault()));
        }
    }

    static /* synthetic */ Table access$000(MessageView x0) {
        return x0.msgTable;
    }

    static /* synthetic */ BeanItem access$102(MessageView x0, BeanItem x1) {
        x0.selectedMsgItem = x1;
        return x0.selectedMsgItem;
    }

    static /* synthetic */ BeanItemContainer access$200(MessageView x0) {
        return x0.msgContainer;
    }

    static /* synthetic */ BeanItem access$100(MessageView x0) {
        return x0.selectedMsgItem;
    }

    static /* synthetic */ void access$300(MessageView x0, BeanItem x1) {
        x0.createMsgDetailLayout(x1);
    }

    static /* synthetic */ Button access$400(MessageView x0) {
        return x0.deleteBtn;
    }

    static /* synthetic */ VerticalLayout access$500(MessageView x0) {
        return x0.msgDetailLayout;
    }

    static /* synthetic */ Label access$600(MessageView x0) {
        return x0.selectMsg;
    }

    static /* synthetic */ FwaMsgController access$700(MessageView x0) {
        return x0.msgController;
    }

    static /* synthetic */ ApplicationContext access$800(MessageView x0) {
        return x0.applicationContext;
    }

    static /* synthetic */ FwaNotMsgController access$900(MessageView x0) {
        return x0.notMsgController;
    }

    static /* synthetic */ BeanItemContainer access$202(MessageView x0, BeanItemContainer x1) {
        x0.msgContainer = x1;
        return x0.msgContainer;
    }

    static /* synthetic */ void access$1000(MessageView x0) {
        x0.customTable();
    }

    static /* synthetic */ TextArea access$1100(MessageView x0) {
        return x0.msgText;
    }

    static /* synthetic */ DateField access$1200(MessageView x0) {
        return x0.dateDebutField;
    }

    static /* synthetic */ DateField access$1300(MessageView x0) {
        return x0.dateFinField;
    }

    static /* synthetic */ FieldGroup access$1400(MessageView x0) {
        return x0.fieldGroup;
    }

    static /* synthetic */ Log access$1500(MessageView x0) {
        return x0.logger;
    }

    static /* synthetic */ void access$1600(MessageView x0, FwaMsg x1) {
        x0.saveAndNotify(x1);
    }

    static /* synthetic */ FwaMsg access$1700(MessageView x0) {
        return x0.newFwaMsg;
    }
}

