/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.views;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Page;
import com.vaadin.server.Sizeable;
import com.vaadin.server.StreamResource;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.ListSelect;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import fr.univlorraine.fwa.controllers.FwaAdmController;
import fr.univlorraine.fwa.controllers.FwaAppController;
import fr.univlorraine.fwa.controllers.FwaCptController;
import fr.univlorraine.fwa.controllers.FwaDomController;
import fr.univlorraine.fwa.controllers.FwaMsgController;
import fr.univlorraine.fwa.controllers.FwaNotMsgController;
import fr.univlorraine.fwa.controllers.FwaUtiController;
import fr.univlorraine.fwa.controllers.UserController;
import fr.univlorraine.fwa.entities.FwaApp;
import fr.univlorraine.fwa.entities.FwaApp_;
import fr.univlorraine.fwa.entities.FwaCpt;
import fr.univlorraine.fwa.entities.FwaDom;
import fr.univlorraine.fwa.entities.FwaMsg;
import fr.univlorraine.fwa.entities.FwaUti;
import fr.univlorraine.fwa.utils.Utils;
import fr.univlorraine.fwa.views.ConnexionView;
import fr.univlorraine.fwa.views.windows.UserMsgWindow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import ru.xpoft.vaadin.VaadinView;

@Component
@Scope(value="prototype")
@VaadinView(value="connexion")
public class ConnexionView
extends VerticalLayout
implements View {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "connexion";
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final int COMPO_WIDTH = 250;
    private static final int DOMAIN_ROW_NUMBER = 12;
    @Resource
    private transient ApplicationContext applicationContext;
    @Resource
    private transient FwaMsgController msgController;
    @Resource
    private transient FwaAdmController admController;
    @Resource
    private transient FwaNotMsgController notMsgController;
    @Resource
    private transient FwaUtiController fwaUtiController;
    @Resource
    private transient UserController userController;
    @Resource
    private transient FwaCptController cptController;
    @Resource
    private transient FwaDomController domController;
    @Resource
    private transient FwaAppController appController;
    @Value(value="${base.temoinEnService}")
    private transient char TES;
    private ThemeResource connectIcon = new ThemeResource("icons/database_connect.png");
    private Label title = new Label();
    private FormLayout formLayout = new FormLayout();
    private NativeSelect applicationField = new NativeSelect();
    private NativeSelect compteField = new NativeSelect();
    private ListSelect domaineSelect = new ListSelect();
    private Button connexButton = new Button();
    private Button downloadButton = new Button();
    private BeanItemContainer<FwaApp> appContainer;
    private List<FwaMsg> msgListe;
    private FwaUti utilisateur = new FwaUti();
    private FwaApp selectedApp = new FwaApp();
    private FwaCpt selectedCpt = new FwaCpt();
    private FwaDom selectedDom = new FwaDom();

    @PostConstruct
    public void init() {
        this.setWidth(500.0f, Sizeable.Unit.PIXELS);
        this.utilisateur = this.fwaUtiController.findUserInDb(this.userController.getCurrentUserName());
        if (!(this.admController.isAdmin(this.userController.getCurrentUserName()) || this.utilisateur != null && this.utilisateur.getTesUti() == this.TES)) {
            Notification.show((String)this.applicationContext.getMessage("connexionView.user.error", null, Locale.getDefault()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            return;
        }
        this.appContainer = this.appController.getOpenAppContainerForUser(this.userController.getCurrentUserName());
        this.appContainer.sort(new Object[]{FwaApp_.ordApp.getName()}, new boolean[]{true});
        if (this.appContainer.size() == 0) {
            Notification.show((String)this.applicationContext.getMessage("connexionView.noapp.error", null, Locale.getDefault()), (Notification.Type)Notification.Type.WARNING_MESSAGE);
            return;
        }
        this.msgListe = this.msgController.findActualMsgsForUser(this.utilisateur.getIdUti());
        if (!this.msgListe.isEmpty()) {
            UserMsgWindow windowMsg = new UserMsgWindow(this.utilisateur, this.msgListe);
            UI.getCurrent().addWindow((Window)windowMsg);
        }
        this.setMargin(true);
        this.setSpacing(true);
        this.setStyleName("connexionlayout");
        this.addComponent((com.vaadin.ui.Component)this.downloadButton);
        this.downloadButton.setId("downloadButtonId");
        Page.Styles styles = Page.getCurrent().getStyles();
        styles.add("#downloadButtonId {display: none !important}");
        this.title.setCaption(this.applicationContext.getMessage("connexionView.title", null, Locale.getDefault()));
        this.title.setStyleName("titlemarged");
        this.title.addStyleName("h2");
        this.addComponent((com.vaadin.ui.Component)this.title);
        this.formLayout.setMargin(new MarginInfo(false, true, true, true));
        this.formLayout.setSpacing(true);
        this.addComponent((com.vaadin.ui.Component)this.formLayout);
        this.applicationField.setCaption(this.applicationContext.getMessage("connexionView.applicationField", null, Locale.getDefault()));
        this.applicationField.setWidth(250.0f, Sizeable.Unit.PIXELS);
        this.applicationField.setImmediate(true);
        this.applicationField.setRequired(true);
        this.applicationField.setContainerDataSource((Container)this.appContainer);
        this.applicationField.setItemCaptionPropertyId((Object)"libApp");
        this.applicationField.setNullSelectionAllowed(false);
        Utils.selectDefaultOnNativeSelect((NativeSelect)this.applicationField);
        this.setApplication();
        this.formLayout.addComponent((com.vaadin.ui.Component)this.applicationField);
        this.applicationField.addValueChangeListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.compteField.setCaption(this.applicationContext.getMessage("connexionView.compteField", null, Locale.getDefault()));
        this.compteField.setWidth(250.0f, Sizeable.Unit.PIXELS);
        this.compteField.setImmediate(true);
        this.compteField.setRequired(true);
        this.compteField.setContainerDataSource((Container)this.cptController.getOpenCptsForUserAndApp(this.utilisateur.getLoginUti(), this.selectedApp.getCodApp()));
        this.compteField.setItemCaptionPropertyId((Object)"loginCpt");
        Utils.selectDefaultOnNativeSelect((NativeSelect)this.compteField);
        this.compteField.setNullSelectionAllowed(false);
        this.formLayout.addComponent((com.vaadin.ui.Component)this.compteField);
        this.selectedCpt = (FwaCpt)this.compteField.getValue();
        this.compteField.addValueChangeListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.domaineSelect.setCaption(this.applicationContext.getMessage("connexionView.domaineField", null, Locale.getDefault()));
        this.domaineSelect.setWidth(250.0f, Sizeable.Unit.PIXELS);
        this.domaineSelect.setRows(12);
        this.domaineSelect.setImmediate(true);
        this.domaineSelect.setRequired(true);
        this.domaineSelect.setContainerDataSource((Container)this.domController.getOpenDomsForUserAndApp(this.utilisateur.getLoginUti(), this.selectedApp.getCodApp()));
        this.domaineSelect.setItemCaptionPropertyId((Object)"libDom");
        this.domaineSelect.addValueChangeListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.domaineSelect.setNullSelectionAllowed(false);
        this.formLayout.addComponent((com.vaadin.ui.Component)this.domaineSelect);
        this.connexButton.setCaption(this.applicationContext.getMessage("connexionView.connexionBtn", null, Locale.getDefault()));
        this.connexButton.setIcon((com.vaadin.server.Resource)this.connectIcon);
        this.connexButton.setEnabled(false);
        Long now = new Date().getTime();
        if (this.selectedApp.getDatDebCloApp() != null && this.selectedApp.getDatFinCloApp() != null && now > this.selectedApp.getDatDebCloApp().getTime() && now < this.selectedApp.getDatFinCloApp().getTime()) {
            Notification.show((String)this.applicationContext.getMessage("connexionView.app.closed", new Object[]{this.selectedApp.getDatFinCloApp()}, Locale.getDefault()), (Notification.Type)Notification.Type.WARNING_MESSAGE);
            return;
        }
        this.updateDatDerConCpt(this.selectedCpt);
        4 fileDownloader = new /* Unavailable Anonymous Inner Class!! */;
        fileDownloader.extend((AbstractComponent)this.downloadButton);
        this.connexButton.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.formLayout.addComponent((com.vaadin.ui.Component)this.connexButton);
        this.verifAvailableCpt();
    }

    private boolean verifAvailableCpt() {
        if (this.compteField.getContainerDataSource().size() == 0) {
            Notification.show((String)this.applicationContext.getMessage("connexionView.nocpt.error", null, Locale.getDefault()), (Notification.Type)Notification.Type.WARNING_MESSAGE);
            this.domaineSelect.setContainerDataSource(null);
            return false;
        }
        return true;
    }

    public void setApplication() {
        if (this.applicationField.getValue() != null) {
            this.selectedApp = (FwaApp)this.applicationField.getValue();
        }
    }

    public void updateDatDerConCpt(FwaCpt cpt) {
        cpt.setDatDerConCpt(new Date());
        this.cptController.updateDateCpt(cpt);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    private void print_https_cert(HttpsURLConnection con) {
        if (con != null) {
            try {
                Certificate[] certs;
                System.out.println("Response Code : " + con.getResponseCode());
                System.out.println("Cipher Suite : " + con.getCipherSuite());
                System.out.println("\n");
                for (Certificate cert : certs = con.getServerCertificates()) {
                    System.out.println("Cert Type : " + cert.getType());
                    System.out.println("Cert Hash Code : " + cert.hashCode());
                    System.out.println("Cert Public Key Algorithm : " + cert.getPublicKey().getAlgorithm());
                    System.out.println("Cert Public Key Format : " + cert.getPublicKey().getFormat());
                    System.out.println("\n");
                }
            }
            catch (SSLPeerUnverifiedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void print_content(HttpsURLConnection con) {
        if (con != null) {
            try {
                String input;
                System.out.println("****** Content of the URL ********");
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
                while ((input = br.readLine()) != null) {
                    System.out.println(input);
                }
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private StreamResource createResource(String jnlp, String name) {
        return new StreamResource((StreamResource.StreamSource)new /* Unavailable Anonymous Inner Class!! */, name + ".jnlp");
    }

    static /* synthetic */ FwaUti access$000(ConnexionView x0) {
        return x0.utilisateur;
    }

    static /* synthetic */ FwaApp access$100(ConnexionView x0) {
        return x0.selectedApp;
    }

    static /* synthetic */ FwaCptController access$200(ConnexionView x0) {
        return x0.cptController;
    }

    static /* synthetic */ NativeSelect access$300(ConnexionView x0) {
        return x0.compteField;
    }

    static /* synthetic */ boolean access$400(ConnexionView x0) {
        return x0.verifAvailableCpt();
    }

    static /* synthetic */ FwaDomController access$500(ConnexionView x0) {
        return x0.domController;
    }

    static /* synthetic */ ListSelect access$600(ConnexionView x0) {
        return x0.domaineSelect;
    }

    static /* synthetic */ FwaCpt access$702(ConnexionView x0, FwaCpt x1) {
        x0.selectedCpt = x1;
        return x0.selectedCpt;
    }

    static /* synthetic */ FwaDom access$802(ConnexionView x0, FwaDom x1) {
        x0.selectedDom = x1;
        return x0.selectedDom;
    }

    static /* synthetic */ Button access$900(ConnexionView x0) {
        return x0.connexButton;
    }

    static /* synthetic */ FwaCpt access$700(ConnexionView x0) {
        return x0.selectedCpt;
    }

    static /* synthetic */ FwaDom access$800(ConnexionView x0) {
        return x0.selectedDom;
    }

    static /* synthetic */ StreamResource access$1000(ConnexionView x0, String x1, String x2) {
        return x0.createResource(x1, x2);
    }

    static /* synthetic */ ApplicationContext access$1100(ConnexionView x0) {
        return x0.applicationContext;
    }
}

